/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aesh.readline.terminal.impl.LineDisciplineTerminal;

public class ExternalTerminal
extends LineDisciplineTerminal {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Thread pumpThread;
    protected final InputStream masterInput;

    public ExternalTerminal(String name, String type, InputStream masterInput, OutputStream masterOutput) throws IOException {
        super(name, type, masterOutput);
        this.masterInput = masterInput;
        this.pumpThread = new Thread(this::pump, this.toString() + " input pump thread");
        this.pumpThread.setDaemon(true);
        this.pumpThread.start();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.pumpThread.interrupt();
            super.close();
        }
    }

    public void pump() {
        block6: {
            try {
                while (true) {
                    int c;
                    if ((c = this.masterInput.read()) < 0 || this.closed.get()) {
                        this.closeSlaveInputPipe();
                        break;
                    }
                    this.processInputByte((char)c);
                }
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (Throwable t) {
                    e.addSuppressed(t);
                }
                if (this.closed.get()) break block6;
                e.printStackTrace();
            }
        }
    }
}

