/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.impl.protocol.Codec20;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;

public class Codec21
extends Codec20 {
    private static final Log log = LogFactory.getLog(Codec21.class, Log.class);

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        return this.writeHeader(buf, params, (byte)21);
    }

    @Override
    public void writeClientListenerParams(ByteBuf buf, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        super.writeClientListenerParams(buf, clientListener, filterFactoryParams, converterFactoryParams);
        buf.writeByte((int)((short)(clientListener.useRawData() ? 1 : 0)));
    }

    @Override
    protected ClientEvent readPartialEvent(ByteBuf buf, byte[] expectedListenerId, Marshaller marshaller, short eventTypeId, List<String> whitelist, SocketAddress serverAddress) {
        boolean isRetried;
        ClientEvent.Type eventType;
        short status = buf.readUnsignedByte();
        buf.readUnsignedByte();
        switch (eventTypeId) {
            case 96: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
                break;
            }
            case 97: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
                break;
            }
            case 98: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
                break;
            }
            case 99: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED;
                break;
            }
            case 80: {
                this.checkForErrorsInResponseStatus(buf, null, status, serverAddress);
            }
            default: {
                throw log.unknownEvent(eventTypeId);
            }
        }
        byte[] listenerId = ByteBufUtil.readArray(buf);
        if (!Arrays.equals(listenerId, expectedListenerId)) {
            throw log.unexpectedListenerId(Util.printArray((byte[])listenerId), Util.printArray((byte[])expectedListenerId));
        }
        short isCustom = buf.readUnsignedByte();
        boolean bl = isRetried = buf.readUnsignedByte() == 1;
        if (isCustom == 1) {
            Object eventData = MarshallerUtil.bytes2obj(marshaller, ByteBufUtil.readArray(buf), status, whitelist);
            return this.createCustomEvent(eventData, eventType, isRetried);
        }
        if (isCustom == 2) {
            return this.createCustomEvent(ByteBufUtil.readArray(buf), eventType, isRetried);
        }
        switch (eventType) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                Object createdKey = MarshallerUtil.bytes2obj(marshaller, ByteBufUtil.readArray(buf), status, whitelist);
                long createdDataVersion = buf.readLong();
                return this.createCreatedEvent(createdKey, createdDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                Object modifiedKey = MarshallerUtil.bytes2obj(marshaller, ByteBufUtil.readArray(buf), status, whitelist);
                long modifiedDataVersion = buf.readLong();
                return this.createModifiedEvent(modifiedKey, modifiedDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                Object removedKey = MarshallerUtil.bytes2obj(marshaller, ByteBufUtil.readArray(buf), status, whitelist);
                return this.createRemovedEvent(removedKey, isRetried);
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                Object expiredKey = MarshallerUtil.bytes2obj(marshaller, ByteBufUtil.readArray(buf), status, whitelist);
                return this.createExpiredEvent(expiredKey);
            }
        }
        throw this.getLog().unknownEvent(eventTypeId);
    }

    protected ClientEvent createExpiredEvent(final Object key) {
        return new ClientCacheEntryExpiredEvent(){

            public Object getKey() {
                return key;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED;
            }

            public String toString() {
                return "ClientCacheEntryExpiredEvent(key=" + key + ")";
            }
        };
    }
}

