/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.msc.service.ServiceName;

final class PackageUtils {
    private PackageUtils() {
    }

    static ServiceName getEndpointConfigServiceName(String configName) {
        return WSServices.ENDPOINT_CONFIG_SERVICE.append(new String[]{configName});
    }

    static ServiceName getClientConfigServiceName(String configName) {
        return WSServices.CLIENT_CONFIG_SERVICE.append(new String[]{configName});
    }

    static ServiceName getConfigServiceName(String configType, String configName) {
        return "endpoint-config".equals(configType) ? PackageUtils.getEndpointConfigServiceName(configName) : PackageUtils.getClientConfigServiceName(configName);
    }

    static ServiceName getHandlerChainServiceName(ServiceName configServiceName, String handlerChainType, String handlerChainId) {
        return configServiceName.append(new String[]{handlerChainType}).append(new String[]{handlerChainId});
    }

    static ServiceName getHandlerServiceName(ServiceName handlerChainServiceName, String handlerName) {
        return handlerChainServiceName.append(new String[]{"handler"}).append(new String[]{handlerName});
    }

    static ServiceName getPropertyServiceName(ServiceName configServiceName, String propertyName) {
        return configServiceName.append(new String[]{"property"}).append(new String[]{propertyName});
    }

    static List<ServiceName> getServiceNameDependencies(OperationContext context, ServiceName baseServiceName, PathAddress address, String childType) {
        LinkedList<ServiceName> childrenServiceNames = new LinkedList<ServiceName>();
        Resource resource = context.readResourceFromRoot(address, false);
        ServiceName sn = baseServiceName.append(new String[]{childType});
        for (String name : resource.getChildrenNames(childType)) {
            childrenServiceNames.add(sn.append(new String[]{name}));
        }
        return childrenServiceNames;
    }
}

