/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import java.time.Duration;
import java.util.Arrays;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerService;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.mod_cluster.undertow.UndertowEventHandlerAdapter;
import org.wildfly.mod_cluster.undertow.UndertowEventHandlerAdapterConfiguration;

public class UndertowEventHandlerAdapterBuilder
implements CapabilityServiceBuilder<Void>,
UndertowEventHandlerAdapterConfiguration {
    static final ServiceName SERVICE_NAME = ContainerEventHandlerService.SERVICE_NAME.append(new String[]{"undertow"});
    private final String listenerName;
    private final Duration statusInterval;
    private final InjectedValue<ContainerEventHandler> eventHandler = new InjectedValue();
    private final InjectedValue<SuspendController> suspendController = new InjectedValue();
    private volatile ValueDependency<UndertowService> service;
    private volatile ValueDependency<UndertowListener> listener;

    public UndertowEventHandlerAdapterBuilder(String listenerName, Duration statusInterval) {
        this.listenerName = listenerName;
        this.statusInterval = statusInterval;
    }

    public ServiceName getServiceName() {
        return SERVICE_NAME;
    }

    public Builder<Void> configure(CapabilityServiceSupport support) {
        this.service = new InjectedValueDependency(support.getCapabilityServiceName("org.wildfly.undertow"), UndertowService.class);
        this.listener = new InjectedValueDependency(support.getCapabilityServiceName("org.wildfly.undertow.listener", new String[]{this.listenerName}), UndertowListener.class);
        return this;
    }

    public ServiceBuilder<Void> build(ServiceTarget target) {
        ServiceBuilder builder = new AsynchronousServiceBuilder(SERVICE_NAME, (Service)new UndertowEventHandlerAdapter(this)).build(target).addDependency(ContainerEventHandlerService.SERVICE_NAME, ContainerEventHandler.class, this.eventHandler).addDependency(SuspendController.SERVICE_NAME, SuspendController.class, this.suspendController);
        for (ValueDependency dependency : Arrays.asList(this.service, this.listener)) {
            dependency.register(builder);
        }
        return builder;
    }

    @Override
    public Duration getStatusInterval() {
        return this.statusInterval;
    }

    @Override
    public UndertowService getUndertowService() {
        return (UndertowService)this.service.getValue();
    }

    @Override
    public ContainerEventHandler getContainerEventHandler() {
        return (ContainerEventHandler)this.eventHandler.getValue();
    }

    @Override
    public SuspendController getSuspendController() {
        return (SuspendController)this.suspendController.getValue();
    }

    @Override
    public UndertowListener getListener() {
        return (UndertowListener)this.listener.getValue();
    }
}

