/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.internal.entities.mapper.id.AbstractCompositeIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.strategy.AuditStrategy;

public final class OneAuditEntityQueryGenerator
extends AbstractRelationQueryGenerator {
    private final String queryString;
    private final String queryRemovedString;
    private final String mappedBy;
    private final boolean multipleIdMapperKey;

    public OneAuditEntityQueryGenerator(GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, AuditStrategy auditStrategy, MiddleIdData referencingIdData, String referencedEntityName, MiddleIdData referencedIdData, boolean revisionTypeInId, String mappedBy, boolean mappedByKey) {
        super(verEntCfg, referencingIdData, revisionTypeInId);
        this.mappedBy = mappedBy;
        this.multipleIdMapperKey = referencedIdData.getOriginalMapper() instanceof AbstractCompositeIdMapper && mappedByKey;
        QueryBuilder commonPart = this.commonQueryPart(verEntCfg.getAuditEntityName(referencedEntityName));
        QueryBuilder validQuery = commonPart.deepCopy();
        QueryBuilder removedQuery = commonPart.deepCopy();
        this.createValidDataRestrictions(globalCfg, auditStrategy, referencedIdData, validQuery, validQuery.getRootParameters());
        this.createValidAndRemovedDataRestrictions(globalCfg, auditStrategy, referencedIdData, removedQuery);
        this.queryString = this.queryToString(validQuery);
        this.queryRemovedString = this.queryToString(removedQuery);
    }

    private QueryBuilder commonQueryPart(String versionsReferencedEntityName) {
        QueryBuilder qb = new QueryBuilder(versionsReferencedEntityName, "e__");
        qb.addProjection(null, "e__", null, false);
        if (this.multipleIdMapperKey) {
            IdMapper mapper = this.getMultipleIdPrefixedMapper();
            mapper.addNamedIdEqualsToQuery(qb.getRootParameters(), null, this.referencingIdData.getPrefixedMapper(), true);
        } else {
            this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(qb.getRootParameters(), null, true);
        }
        return qb;
    }

    private void createValidDataRestrictions(GlobalConfiguration globalCfg, AuditStrategy auditStrategy, MiddleIdData referencedIdData, QueryBuilder qb, Parameters rootParameters) {
        String revisionPropertyPath = this.verEntCfg.getRevisionNumberPath();
        auditStrategy.addEntityAtRevisionRestriction(globalCfg, qb, rootParameters, revisionPropertyPath, this.verEntCfg.getRevisionEndFieldName(), true, referencedIdData, revisionPropertyPath, this.verEntCfg.getOriginalIdPropName(), "e__", "e2__", true);
        rootParameters.addWhereWithNamedParam(this.getRevisionTypePath(), false, "!=", "delrevisiontype");
    }

    private void createValidAndRemovedDataRestrictions(GlobalConfiguration globalCfg, AuditStrategy auditStrategy, MiddleIdData referencedIdData, QueryBuilder remQb) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        this.createValidDataRestrictions(globalCfg, auditStrategy, referencedIdData, remQb, valid);
        removed.addWhereWithNamedParam(this.verEntCfg.getRevisionNumberPath(), false, "=", "revision");
        removed.addWhereWithNamedParam(this.getRevisionTypePath(), false, "=", "delrevisiontype");
    }

    @Override
    protected String getQueryString() {
        return this.queryString;
    }

    @Override
    protected String getQueryRemovedString() {
        return this.queryRemovedString;
    }

    private IdMapper getMultipleIdPrefixedMapper() {
        String prefix = this.verEntCfg.getOriginalIdPropName() + "." + this.mappedBy + ".";
        return this.referencingIdData.getOriginalMapper().prefixMappedProperties(prefix);
    }
}

