/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.jboss.logging.Logger;

public final class OrderedExecutorFactory
implements ExecutorFactory {
    private static final Logger logger = Logger.getLogger(OrderedExecutorFactory.class);
    private final Executor parent;

    public static boolean flushExecutor(Executor executor) {
        return OrderedExecutorFactory.flushExecutor(executor, 30L, TimeUnit.SECONDS);
    }

    public static boolean flushExecutor(Executor executor, long timeout, TimeUnit unit) {
        CountDownLatch latch = new CountDownLatch(1);
        executor.execute(latch::countDown);
        try {
            return latch.await(timeout, unit);
        }
        catch (Exception e) {
            return false;
        }
    }

    public OrderedExecutorFactory(Executor parent) {
        this.parent = parent;
    }

    @Override
    public Executor getExecutor() {
        return new OrderedExecutor(this.parent);
    }

    public static class OrderedExecutor
    implements Executor {
        private final Queue<Runnable> tasks = new ConcurrentLinkedQueue<Runnable>();
        private final Executor delegate;
        private final ExecutorTask task = new ExecutorTask();
        private volatile int state = 0;
        private static final AtomicIntegerFieldUpdater<OrderedExecutor> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(OrderedExecutor.class, "state");
        private static final int STATE_NOT_RUNNING = 0;
        private static final int STATE_RUNNING = 1;

        private OrderedExecutor(Executor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void execute(Runnable command) {
            this.tasks.add(command);
            if (stateUpdater.get(this) == 0) {
                this.delegate.execute(this.task);
            }
        }

        public boolean isFlushed() {
            return stateUpdater.get(this) == 0;
        }

        public String toString() {
            return "OrderedExecutor(tasks=" + this.tasks + ")";
        }

        private final class ExecutorTask
        implements Runnable {
            private ExecutorTask() {
            }

            @Override
            public void run() {
                do {
                    if (stateUpdater.compareAndSet(OrderedExecutor.this, 0, 1)) {
                        Runnable task = (Runnable)OrderedExecutor.this.tasks.poll();
                        while (task != null) {
                            try {
                                task.run();
                            }
                            catch (ActiveMQInterruptedException e) {
                                logger.debug((Object)"Interrupted Thread", (Throwable)e);
                            }
                            catch (Throwable t) {
                                logger.warn((Object)t.getMessage(), t);
                            }
                            task = (Runnable)OrderedExecutor.this.tasks.poll();
                        }
                    } else {
                        return;
                    }
                    stateUpdater.set(OrderedExecutor.this, 0);
                } while (!OrderedExecutor.this.tasks.isEmpty());
            }
        }
    }
}

