/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.function.Predicate;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismInformation;

@FunctionalInterface
public interface MechanismConfigurationSelector {
    public MechanismConfiguration selectConfiguration(MechanismInformation var1);

    public static MechanismConfigurationSelector predicateSelector(Predicate<MechanismInformation> predicate, MechanismConfiguration mechanismConfiguration) {
        return information -> predicate.test(information) ? mechanismConfiguration : null;
    }

    public static MechanismConfigurationSelector aggregate(MechanismConfigurationSelector ... configurationSelectors) {
        return information -> {
            for (MechanismConfigurationSelector current : configurationSelectors) {
                MechanismConfiguration configuration = current.selectConfiguration(information);
                if (configuration == null) continue;
                return configuration;
            }
            return null;
        };
    }

    public static MechanismConfigurationSelector constantSelector(MechanismConfiguration mechanismConfiguration) {
        return information -> mechanismConfiguration;
    }
}

