/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.messaging.AttributeMarshallers;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.ConnectionFactoryAttribute;
import org.jboss.as.messaging.jms.ConnectionFactoryType;
import org.jboss.as.messaging.jms.Validators;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public interface ConnectionFactoryAttributes {

    public static interface Pooled {
        public static final String USE_JNDI_PROP_NAME = "useJNDI";
        public static final String SETUP_ATTEMPTS_PROP_NAME = "setupAttempts";
        public static final String SETUP_INTERVAL_PROP_NAME = "setupInterval";
        public static final String RECONNECT_ATTEMPTS_PROP_NAME = "reconnectAttempts";
        public static final SimpleAttributeDefinition INITIAL_CONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-connect-attempts", (ModelType)ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(1))).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition INITIAL_MESSAGE_PACKET_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-message-packet-size", (ModelType)ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(1500))).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition JNDI_PARAMS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jndi-params", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition MAX_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-pool-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(-1))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition MIN_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"min-pool-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(-1))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"password", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)CommonAttributes.MESSAGING_SECURITY_DEF)).build();
        public static final AttributeDefinition RECONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(-1))).setRequired(false)).setAllowExpression(true)).build();
        public static final SimpleAttributeDefinition SETUP_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"setup-attempts", (ModelType)ModelType.INT).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition SETUP_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"setup-interval", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition TRANSACTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode().set("transaction"))).setRequired(false)).setAllowExpression(true)).setAttributeMarshaller(new AttributeMarshaller(){

            public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
                if (this.isMarshallable(attribute, resourceModel)) {
                    writer.writeStartElement(attribute.getXmlName());
                    writer.writeAttribute(Element.MODE.getLocalName(), resourceModel.get(attribute.getName()).asString());
                    writer.writeEndElement();
                }
            }
        })).setRestartAllServices()).build();
        public static final AttributeDefinition USE_AUTO_RECOVERY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-auto-recovery", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(true))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final AttributeDefinition USE_JNDI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-jndi", (ModelType)ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final AttributeDefinition USE_LOCAL_TX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-local-tx", (ModelType)ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"user", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)CommonAttributes.MESSAGING_SECURITY_DEF)).build();
        public static final ConnectionFactoryAttribute[] ATTRIBUTES = new ConnectionFactoryAttribute[]{ConnectionFactoryAttribute.create(USE_JNDI, "useJNDI", true, true), ConnectionFactoryAttribute.create((AttributeDefinition)JNDI_PARAMS, "jndiParams", true, true), ConnectionFactoryAttribute.create(USE_LOCAL_TX, "useLocalTx", true, true), ConnectionFactoryAttribute.create((AttributeDefinition)SETUP_ATTEMPTS, "setupAttempts", true, true), ConnectionFactoryAttribute.create((AttributeDefinition)SETUP_INTERVAL, "setupInterval", true, true), ConnectionFactoryAttribute.create((AttributeDefinition)TRANSACTION, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)USER, "userName", true), ConnectionFactoryAttribute.create((AttributeDefinition)PASSWORD, "password", true), ConnectionFactoryAttribute.create((AttributeDefinition)MIN_POOL_SIZE, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)MAX_POOL_SIZE, null, false), ConnectionFactoryAttribute.create(USE_AUTO_RECOVERY, "useAutoRecovery", true), ConnectionFactoryAttribute.create((AttributeDefinition)INITIAL_MESSAGE_PACKET_SIZE, "initialMessagePacketSize", true), ConnectionFactoryAttribute.create((AttributeDefinition)INITIAL_CONNECT_ATTEMPTS, "initialConnectAttempts", true)};
    }

    public static interface Regular {
        public static final AttributeDefinition FACTORY_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"factory-type", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode().set(ConnectionFactoryType.GENERIC.toString()))).setValidator(ConnectionFactoryType.VALIDATOR)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{FACTORY_TYPE};
        public static final AttributeDefinition INITIAL_MESSAGE_PACKET_SIZE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-message-packet-size", (ModelType)ModelType.INT).setStorageRuntime()).build();
    }

    public static interface Common {
        public static final AttributeDefinition AUTO_GROUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"auto-group", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition BLOCK_ON_ACKNOWLEDGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"block-on-acknowledge", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition BLOCK_ON_DURABLE_SEND = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"block-on-durable-send", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(true))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition BLOCK_ON_NON_DURABLE_SEND = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"block-on-non-durable-send", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition CACHE_LARGE_MESSAGE_CLIENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cache-large-message-client", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition CLIENT_FAILURE_CHECK_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"client-failure-check-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(30000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition COMPRESS_LARGE_MESSAGES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"compress-large-messages", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition CONFIRMATION_WINDOW_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"confirmation-window-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(-1))).setMeasurementUnit(MeasurementUnit.BYTES)).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition CONNECTION_LOAD_BALANCING_CLASS_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connection-load-balancing-policy-class-name", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode().set("org.hornetq.api.core.client.loadbalance.RoundRobinConnectionLoadBalancingPolicy"))).setRequired(false)).setAllowExpression(false)).build();
        public static final AttributeDefinition CONNECTION_TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-ttl", ModelType.LONG).setDefaultValue(new ModelNode().set(60000L))).setRequired(false)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).build();
        public static final AttributeDefinition CONNECTOR = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("connector", true).setAlternatives(new String[]{"discovery-group-name"})).setAttributeMarshaller(AttributeMarshallers.CONNECTORS_MARSHALLER)).setCorrector(new ParameterCorrector(){

            public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
                if (newValue.getType() != ModelType.LIST) {
                    return newValue;
                }
                ModelNode correctValue = new ModelNode();
                for (ModelNode node : newValue.asList()) {
                    correctValue.get(node.asString());
                }
                return correctValue;
            }
        })).setRestartAllServices()).build();
        public static final AttributeDefinition CONSUMER_MAX_RATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"consumer-max-rate", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(-1))).setMeasurementUnit(MeasurementUnit.PER_SECOND)).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition CONSUMER_WINDOW_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"consumer-window-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0x100000))).setMeasurementUnit(MeasurementUnit.BYTES)).setRequired(false)).setAllowExpression(true)).build();
        public static final SimpleAttributeDefinition DISCOVERY_GROUP_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"discovery-group-name", (ModelType)ModelType.STRING).setRequired(false)).setAlternatives(new String[]{"connector"})).setAttributeMarshaller(AttributeMarshallers.DISCOVERY_GROUP_MARSHALLER)).setRestartAllServices()).build();
        public static final AttributeDefinition DISCOVERY_INITIAL_WAIT_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"discovery-initial-wait-timeout", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setRestartAllServices()).setDeprecated(MessagingExtension.VERSION_1_1_0)).setAttributeMarshaller(AttributeMarshallers.NOOP_MARSHALLER)).build();
        public static final AttributeDefinition DUPS_OK_BATCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"dups-ok-batch-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0x100000))).setRequired(false)).setAllowExpression(true)).build();
        public static final ListAttributeDefinition ENTRIES = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"entries", (ModelType)ModelType.STRING).setRequired(true)).setAllowExpression(true)).setRestartAllServices()).setListValidator((ParameterValidator)Validators.noDuplicateElements((ParameterValidator)new StringLengthValidator(1, false, true)))).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.JndiEntriesAttributeMarshaller(false))).build();
        public static final AttributeDefinition FAILOVER_ON_INITIAL_CONNECTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"failover-on-initial-connection", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition FAILOVER_ON_SERVER_SHUTDOWN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"failover-on-server-shutdown", (ModelType)ModelType.BOOLEAN).setRequired(false)).setRestartAllServices()).setDeprecated(MessagingExtension.VERSION_1_1_0)).build();
        public static final AttributeDefinition GROUP_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"group-id", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition MAX_RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(2000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition MIN_LARGE_MESSAGE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"min-large-message-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(102400))).setMeasurementUnit(MeasurementUnit.BYTES)).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition PRE_ACKNOWLEDGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"pre-acknowledge", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition PRODUCER_MAX_RATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"producer-max-rate", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(-1))).setMeasurementUnit(MeasurementUnit.PER_SECOND)).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition PRODUCER_WINDOW_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"producer-window-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(65536))).setMeasurementUnit(MeasurementUnit.BYTES)).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition RECONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(2000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition RETRY_INTERVAL_MULTIPLIER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"retry-interval-multiplier", (ModelType)ModelType.DOUBLE).setDefaultValue(new ModelNode().set(1.0))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition SCHEDULED_THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scheduled-thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(5))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(30))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition TRANSACTION_BATCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction-batch-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0x100000))).setRequired(false)).setAllowExpression(true)).build();
        public static final AttributeDefinition USE_GLOBAL_POOLS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-global-pools", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(true))).setRequired(false)).setAllowExpression(true)).build();
        public static final ConnectionFactoryAttribute[] ATTRIBUTES = new ConnectionFactoryAttribute[]{ConnectionFactoryAttribute.create((AttributeDefinition)DISCOVERY_GROUP_NAME, null, false), ConnectionFactoryAttribute.create(CONNECTOR, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)ENTRIES, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)CommonAttributes.HA, "HA", true), ConnectionFactoryAttribute.create(CLIENT_FAILURE_CHECK_PERIOD, "clientFailureCheckPeriod", true), ConnectionFactoryAttribute.create(CONNECTION_TTL, "connectionTTL", true), ConnectionFactoryAttribute.create(CommonAttributes.CALL_TIMEOUT, "callTimeout", true), ConnectionFactoryAttribute.create((AttributeDefinition)CommonAttributes.CALL_FAILOVER_TIMEOUT, "callFailoverTimeout", true), ConnectionFactoryAttribute.create(CONSUMER_WINDOW_SIZE, "consumerWindowSize", true), ConnectionFactoryAttribute.create(CONSUMER_MAX_RATE, "consumerMaxRate", true), ConnectionFactoryAttribute.create(CONFIRMATION_WINDOW_SIZE, "confirmationWindowSize", true), ConnectionFactoryAttribute.create(PRODUCER_WINDOW_SIZE, "producerWindowSize", true), ConnectionFactoryAttribute.create(PRODUCER_MAX_RATE, "producerMaxRate", true), ConnectionFactoryAttribute.create(COMPRESS_LARGE_MESSAGES, "compressLargeMessage", true), ConnectionFactoryAttribute.create(CACHE_LARGE_MESSAGE_CLIENT, "cacheLargeMessagesClient", true), ConnectionFactoryAttribute.create(CommonAttributes.MIN_LARGE_MESSAGE_SIZE, "minLargeMessageSize", true), ConnectionFactoryAttribute.create((AttributeDefinition)CommonAttributes.CLIENT_ID, "clientID", true), ConnectionFactoryAttribute.create(DUPS_OK_BATCH_SIZE, "dupsOKBatchSize", true), ConnectionFactoryAttribute.create(TRANSACTION_BATCH_SIZE, "transactionBatchSize", true), ConnectionFactoryAttribute.create(BLOCK_ON_ACKNOWLEDGE, "blockOnAcknowledge", true), ConnectionFactoryAttribute.create(BLOCK_ON_NON_DURABLE_SEND, "blockOnNonDurableSend", true), ConnectionFactoryAttribute.create(BLOCK_ON_DURABLE_SEND, "blockOnDurableSend", true), ConnectionFactoryAttribute.create(AUTO_GROUP, "autoGroup", true), ConnectionFactoryAttribute.create(PRE_ACKNOWLEDGE, "preAcknowledge", true), ConnectionFactoryAttribute.create(RETRY_INTERVAL, "retryInterval", true), ConnectionFactoryAttribute.create(RETRY_INTERVAL_MULTIPLIER, "retryIntervalMultiplier", true), ConnectionFactoryAttribute.create(CommonAttributes.MAX_RETRY_INTERVAL, "maxRetryInterval", true), ConnectionFactoryAttribute.create(RECONNECT_ATTEMPTS, null, false), ConnectionFactoryAttribute.create(FAILOVER_ON_INITIAL_CONNECTION, "failoverOnInitialConnection", true), ConnectionFactoryAttribute.create(FAILOVER_ON_SERVER_SHUTDOWN, "failoverOnServerShutdown", false), ConnectionFactoryAttribute.create(CONNECTION_LOAD_BALANCING_CLASS_NAME, "connectionLoadBalancingPolicyClassName", true), ConnectionFactoryAttribute.create(USE_GLOBAL_POOLS, "useGlobalPools", true), ConnectionFactoryAttribute.create(SCHEDULED_THREAD_POOL_MAX_SIZE, "scheduledThreadPoolMaxSize", true), ConnectionFactoryAttribute.create(THREAD_POOL_MAX_SIZE, "threadPoolMaxSize", true), ConnectionFactoryAttribute.create(GROUP_ID, "groupID", true), ConnectionFactoryAttribute.create(DISCOVERY_INITIAL_WAIT_TIMEOUT, null, false)};
    }
}

