/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import com.sun.tools.corba.se.idl.AttributeEntry;
import com.sun.tools.corba.se.idl.ConstEntry;
import com.sun.tools.corba.se.idl.EnumEntry;
import com.sun.tools.corba.se.idl.ExceptionEntry;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.ModuleEntry;
import com.sun.tools.corba.se.idl.ParameterEntry;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.RepositoryID;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.StructEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.UnionEntry;
import com.sun.tools.corba.se.idl.som.cff.FileLocator;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Util {
    private static Properties messages = null;
    private static String defaultKey = "default";
    private static Vector msgFiles = new Vector();
    static RepositoryID emptyID;

    public static String getVersion() {
        return Util.getVersion("com/sun/tools/corba/se/idl/idl.prp");
    }

    public static String getVersion(String filename) {
        String version = "";
        if (messages == null) {
            Vector oldMsgFiles = msgFiles;
            if (filename == null || filename.equals("")) {
                filename = "com/sun/tools/corba/se/idl/idl.prp";
            }
            filename = filename.replace('/', File.separatorChar);
            Util.registerMessageFile(filename);
            version = Util.getMessage("Version.product", Util.getMessage("Version.number"));
            msgFiles = oldMsgFiles;
            messages = null;
        } else {
            version = Util.getMessage("Version.product", Util.getMessage("Version.number"));
        }
        return version;
    }

    public static boolean isAttribute(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof AttributeEntry;
    }

    public static boolean isConst(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof ConstEntry;
    }

    public static boolean isEnum(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof EnumEntry;
    }

    public static boolean isException(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof ExceptionEntry;
    }

    public static boolean isInterface(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof InterfaceEntry;
    }

    public static boolean isMethod(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof MethodEntry;
    }

    public static boolean isModule(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof ModuleEntry;
    }

    public static boolean isParameter(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof ParameterEntry;
    }

    public static boolean isPrimitive(String name, Hashtable symbolTable) {
        int parenIndex;
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        if (entry == null && (parenIndex = name.indexOf(40)) >= 0) {
            entry = (SymtabEntry)symbolTable.get(name.substring(0, parenIndex));
        }
        return entry == null ? false : entry instanceof PrimitiveEntry;
    }

    public static boolean isSequence(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof SequenceEntry;
    }

    public static boolean isStruct(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof StructEntry;
    }

    public static boolean isString(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof StringEntry;
    }

    public static boolean isTypedef(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof TypedefEntry;
    }

    public static boolean isUnion(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof UnionEntry;
    }

    public static String getMessage(String key) {
        String message;
        if (messages == null) {
            Util.readMessages();
        }
        if ((message = messages.getProperty(key)) == null) {
            message = Util.getDefaultMessage(key);
        }
        return message;
    }

    public static String getMessage(String key, String fill) {
        String message;
        if (messages == null) {
            Util.readMessages();
        }
        if ((message = messages.getProperty(key)) == null) {
            message = Util.getDefaultMessage(key);
        } else {
            int index = message.indexOf("%0");
            if (index >= 0) {
                message = message.substring(0, index) + fill + message.substring(index + 2);
            }
        }
        return message;
    }

    public static String getMessage(String key, String[] fill) {
        String message;
        if (messages == null) {
            Util.readMessages();
        }
        if ((message = messages.getProperty(key)) == null) {
            message = Util.getDefaultMessage(key);
        } else {
            for (int i = 0; i < fill.length; ++i) {
                int index = message.indexOf("%" + i);
                if (index < 0) continue;
                message = message.substring(0, index) + fill[i] + message.substring(index + 2);
            }
        }
        return message;
    }

    private static String getDefaultMessage(String keyNotFound) {
        String message = messages.getProperty(defaultKey);
        int index = message.indexOf("%0");
        if (index > 0) {
            message = message.substring(0, index) + keyNotFound;
        }
        return message;
    }

    private static void readMessages() {
        messages = new Properties();
        Enumeration fileList = msgFiles.elements();
        while (fileList.hasMoreElements()) {
            try {
                DataInputStream stream = FileLocator.locateLocaleSpecificFileInClassPath((String)fileList.nextElement());
                messages.load(stream);
            }
            catch (IOException iOException) {}
        }
        if (messages.size() == 0) {
            messages.put(defaultKey, "Error reading Messages File.");
        }
    }

    public static void registerMessageFile(String filename) {
        if (filename != null) {
            if (messages == null) {
                msgFiles.addElement(filename);
            } else {
                try {
                    DataInputStream stream = FileLocator.locateLocaleSpecificFileInClassPath(filename);
                    messages.load(stream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static String capitalize(String lc) {
        String first = new String(lc.substring(0, 1));
        first = first.toUpperCase();
        return first + lc.substring(1);
    }

    public static String getAbsolutePath(String filename, Vector includePaths) throws FileNotFoundException {
        String filepath = null;
        File file = new File(filename);
        if (file.canRead()) {
            filepath = file.getAbsolutePath();
        } else {
            String fullname = null;
            Enumeration pathList = includePaths.elements();
            while (!file.canRead() && pathList.hasMoreElements()) {
                fullname = (String)pathList.nextElement() + File.separatorChar + filename;
                file = new File(fullname);
            }
            if (file.canRead()) {
                filepath = file.getPath();
            } else {
                throw new FileNotFoundException(filename);
            }
        }
        return filepath;
    }

    public static float absDelta(float f1, float f2) {
        double delta = f1 - f2;
        return (float)(delta < 0.0 ? delta * -1.0 : delta);
    }

    static {
        msgFiles.addElement("com/sun/tools/corba/se/idl/idl.prp");
        emptyID = new RepositoryID();
    }
}

