/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.ConstEntry;
import com.sun.tools.corba.se.idl.EnumEntry;
import com.sun.tools.corba.se.idl.ExceptionEntry;
import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.NativeEntry;
import com.sun.tools.corba.se.idl.ParameterEntry;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.StructEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.UnionBranch;
import com.sun.tools.corba.se.idl.UnionEntry;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.constExpr.BinaryExpr;
import com.sun.tools.corba.se.idl.constExpr.Divide;
import com.sun.tools.corba.se.idl.constExpr.Expression;
import com.sun.tools.corba.se.idl.constExpr.Minus;
import com.sun.tools.corba.se.idl.constExpr.Not;
import com.sun.tools.corba.se.idl.constExpr.Plus;
import com.sun.tools.corba.se.idl.constExpr.Terminal;
import com.sun.tools.corba.se.idl.constExpr.Times;
import com.sun.tools.corba.se.idl.constExpr.UnaryExpr;
import com.sun.tools.corba.se.idl.toJavaPortable.Arguments;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.NameModifier;
import com.sun.tools.corba.se.idl.toJavaPortable.NameModifierImpl;
import java.io.File;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class Util
extends com.sun.tools.corba.se.idl.Util {
    public static final short TypeFile = 0;
    public static final short StubFile = 1;
    public static final short HelperFile = 2;
    public static final short HolderFile = 3;
    public static final short StateFile = 4;
    static Hashtable symbolTable = new Hashtable();
    static Hashtable packageTranslation = new Hashtable();

    public static String getVersion() {
        return com.sun.tools.corba.se.idl.Util.getVersion("com/sun/tools/corba/se/idl/toJavaPortable/toJavaPortable.prp");
    }

    static void setSymbolTable(Hashtable symtab) {
        symbolTable = symtab;
    }

    public static void setPackageTranslation(Hashtable pkgtrans) {
        packageTranslation = pkgtrans;
    }

    public static boolean isInterface(String name) {
        return Util.isInterface(name, symbolTable);
    }

    static String arrayInfo(Vector arrayInfo) {
        int arrays = arrayInfo.size();
        String info = "";
        Enumeration e = arrayInfo.elements();
        while (e.hasMoreElements()) {
            info = info + '[' + Util.parseExpression((Expression)e.nextElement()) + ']';
        }
        return info;
    }

    public static String sansArrayInfo(Vector arrayInfo) {
        int arrays = arrayInfo.size();
        String brackets = "";
        for (int i = 0; i < arrays; ++i) {
            brackets = brackets + "[]";
        }
        return brackets;
    }

    public static String sansArrayInfo(String name) {
        int index = name.indexOf(91);
        if (index >= 0) {
            String array = name.substring(index);
            name = name.substring(0, index);
            while (!array.equals("")) {
                name = name + "[]";
                array = array.substring(array.indexOf(93) + 1);
            }
        }
        return name;
    }

    public static String fileName(SymtabEntry entry, String extension) {
        NameModifierImpl nm = new NameModifierImpl();
        return Util.fileName(entry, nm, extension);
    }

    public static String fileName(SymtabEntry entry, NameModifier modifier, String extension) {
        String pkg = Util.containerFullName(entry.container());
        if (pkg != null && !pkg.equals("")) {
            Util.mkdir(pkg);
        }
        String name = entry.name();
        name = modifier.makeName(name) + extension;
        if (pkg != null && !pkg.equals("")) {
            name = pkg + '/' + name;
        }
        return name.replace('/', File.separatorChar);
    }

    public static GenFileStream stream(SymtabEntry entry, String extension) {
        NameModifierImpl nm = new NameModifierImpl();
        return Util.stream(entry, nm, extension);
    }

    public static GenFileStream stream(SymtabEntry entry, NameModifier modifier, String extension) {
        return Util.getStream(Util.fileName(entry, modifier, extension), entry);
    }

    public static GenFileStream getStream(String name, SymtabEntry entry) {
        String absPathName = ((Arguments)Compile.compiler.arguments).targetDir + name;
        if (Compile.compiler.arguments.keepOldFiles && new File(absPathName).exists()) {
            return null;
        }
        return new GenFileStream(absPathName);
    }

    public static String containerFullName(SymtabEntry container) {
        String name = Util.doContainerFullName(container);
        if (packageTranslation.size() > 0) {
            name = Util.translate(name);
        }
        return name;
    }

    public static String translate(String name) {
        int index;
        String head = name;
        String tail = "";
        do {
            String trname;
            if ((trname = (String)packageTranslation.get(head)) != null) {
                return trname + tail;
            }
            index = head.lastIndexOf(47);
            if (index < 0) continue;
            tail = head.substring(index) + tail;
            head = head.substring(0, index);
        } while (index >= 0);
        return name;
    }

    private static String doContainerFullName(SymtabEntry container) {
        String name = "";
        if (container == null) {
            name = "";
        } else {
            name = container instanceof InterfaceEntry || container instanceof StructEntry || container instanceof UnionEntry ? container.name() + "Package" : container.name();
            if (container.container() != null && !container.container().name().equals("")) {
                name = Util.doContainerFullName(container.container()) + '/' + name;
            }
        }
        return name;
    }

    public static String javaName(SymtabEntry entry) {
        String name = "";
        if (entry instanceof TypedefEntry || entry instanceof SequenceEntry) {
            try {
                name = Util.sansArrayInfo((String)entry.dynamicVariable(Compile.typedefInfo));
            }
            catch (NoSuchFieldException e) {
                name = entry.name();
            }
        } else if (entry instanceof PrimitiveEntry) {
            name = Util.javaPrimName(entry.name());
        } else if (entry instanceof StringEntry) {
            name = "String";
        } else if (entry instanceof NativeEntry) {
            name = Util.javaNativeName(entry.name());
        } else if (entry instanceof ValueEntry && entry.name().equals("ValueBase")) {
            name = "java.io.Serializable";
        } else if (entry instanceof ValueBoxEntry) {
            ValueBoxEntry v = (ValueBoxEntry)entry;
            TypedefEntry member = ((InterfaceState)v.state().elementAt((int)0)).entry;
            SymtabEntry mType = member.type();
            if (mType instanceof PrimitiveEntry) {
                name = Util.containerFullName(entry.container());
                if (!name.equals("")) {
                    name = name + '.';
                }
                name = name + entry.name();
            } else {
                name = Util.javaName(mType);
            }
        } else {
            name = Util.containerFullName(entry.container());
            name = name.equals("") ? entry.name() : name + '.' + entry.name();
        }
        return name.replace('/', '.');
    }

    public static String javaPrimName(String name) {
        if (name.equals("long") || name.equals("unsigned long")) {
            name = "int";
        } else if (name.equals("octet")) {
            name = "byte";
        } else if (name.equals("long long") || name.equals("unsigned long long")) {
            name = "long";
        } else if (name.equals("wchar")) {
            name = "char";
        } else if (name.equals("unsigned short")) {
            name = "short";
        } else if (name.equals("any")) {
            name = "org.omg.CORBA.Any";
        } else if (name.equals("TypeCode")) {
            name = "org.omg.CORBA.TypeCode";
        } else if (name.equals("Principal")) {
            name = "org.omg.CORBA.Principal";
        }
        return name;
    }

    public static String javaNativeName(String name) {
        if (name.equals("AbstractBase") || name.equals("Cookie")) {
            name = "java.lang.Object";
        } else if (name.equals("Servant")) {
            name = "org.omg.PortableServer.Servant";
        } else if (name.equals("ValueFactory")) {
            name = "org.omg.CORBA.portable.ValueFactory";
        }
        return name;
    }

    public static String javaQualifiedName(SymtabEntry entry) {
        String name = "";
        if (entry instanceof PrimitiveEntry) {
            name = Util.javaPrimName(entry.name());
        } else if (entry instanceof StringEntry) {
            name = "String";
        } else if (entry instanceof ValueEntry && entry.name().equals("ValueBase")) {
            name = "java.io.Serializable";
        } else {
            SymtabEntry container = entry.container();
            if (container != null) {
                name = container.name();
            }
            name = name.equals("") ? entry.name() : Util.containerFullName(entry.container()) + '.' + entry.name();
        }
        return name.replace('/', '.');
    }

    public static String collapseName(String name) {
        if (name.equals("unsigned short")) {
            name = "ushort";
        } else if (name.equals("unsigned long")) {
            name = "ulong";
        } else if (name.equals("unsigned long long")) {
            name = "ulonglong";
        } else if (name.equals("long long")) {
            name = "longlong";
        }
        return name;
    }

    public static SymtabEntry typeOf(SymtabEntry entry) {
        while (entry instanceof TypedefEntry && ((TypedefEntry)entry).arrayInfo().isEmpty() && !(entry.type() instanceof SequenceEntry)) {
            entry = entry.type();
        }
        return entry;
    }

    static void fillInfo(SymtabEntry infoEntry) {
        String arrayInfo = "";
        SymtabEntry entry = infoEntry;
        boolean alreadyHave = false;
        do {
            try {
                alreadyHave = entry.dynamicVariable(Compile.typedefInfo) != null;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (alreadyHave) continue;
            if (entry instanceof TypedefEntry) {
                arrayInfo = arrayInfo + Util.arrayInfo(((TypedefEntry)entry).arrayInfo());
            } else if (entry instanceof SequenceEntry) {
                Expression maxSize = ((SequenceEntry)entry).maxSize();
                arrayInfo = maxSize == null ? arrayInfo + "[]" : arrayInfo + '[' + Util.parseExpression(maxSize) + ']';
            }
            if (entry.type() == null) continue;
            entry = entry.type();
        } while (!alreadyHave && entry != null && (entry instanceof TypedefEntry || entry instanceof SequenceEntry));
        if (entry instanceof ValueBoxEntry) {
            Util.fillValueBoxInfo((ValueBoxEntry)entry);
        }
        try {
            if (alreadyHave) {
                infoEntry.dynamicVariable(Compile.typedefInfo, (String)entry.dynamicVariable(Compile.typedefInfo) + arrayInfo);
            } else {
                infoEntry.dynamicVariable(Compile.typedefInfo, Util.javaName(entry) + arrayInfo);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    static void fillValueBoxInfo(ValueBoxEntry vb) {
        TypedefEntry stateMember = ((InterfaceState)vb.state().elementAt((int)0)).entry;
        if (stateMember.type() != null) {
            Util.fillInfo(stateMember.type());
        }
        Util.fillInfo(stateMember);
    }

    public static String holderName(SymtabEntry entry) {
        TypedefEntry td;
        String name = entry instanceof PrimitiveEntry ? (entry.name().equals("any") ? "org.omg.CORBA.AnyHolder" : (entry.name().equals("TypeCode") ? "org.omg.CORBA.TypeCodeHolder" : (entry.name().equals("Principal") ? "org.omg.CORBA.PrincipalHolder" : "org.omg.CORBA." + Util.capitalize(Util.javaQualifiedName(entry)) + "Holder"))) : (entry instanceof TypedefEntry ? (!(td = (TypedefEntry)entry).arrayInfo().isEmpty() || td.type() instanceof SequenceEntry ? Util.javaQualifiedName(entry) + "Holder" : Util.holderName(entry.type())) : (entry instanceof StringEntry ? "org.omg.CORBA.StringHolder" : (entry instanceof ValueEntry ? (entry.name().equals("ValueBase") ? "org.omg.CORBA.ValueBaseHolder" : Util.javaName(entry) + "Holder") : (entry instanceof NativeEntry ? Util.javaQualifiedName(entry) + "Holder" : Util.javaName(entry) + "Holder"))));
        return name;
    }

    public static String helperName(SymtabEntry entry, boolean qualifiedName) {
        if (entry instanceof ValueEntry && entry.name().equals("ValueBase")) {
            return "org.omg.CORBA.ValueBaseHelper";
        }
        if (qualifiedName) {
            return Util.javaQualifiedName(entry) + "Helper";
        }
        return Util.javaName(entry) + "Helper";
    }

    public static void writePackage(PrintWriter stream, SymtabEntry entry) {
        Util.writePackage(stream, entry, (short)0);
    }

    public static void writePackage(PrintWriter stream, SymtabEntry entry, String name, short type) {
        if (name != null && !name.equals("")) {
            stream.println("package " + name.replace('/', '.') + ';');
            if (!Compile.compiler.importTypes.isEmpty()) {
                stream.println();
                Vector v = Util.addImportLines(entry, Compile.compiler.importTypes, type);
                Util.printImports(v, stream);
            }
        }
    }

    public static void writePackage(PrintWriter stream, SymtabEntry entry, short type) {
        String fullName = Util.containerFullName(entry.container());
        if (fullName != null && !fullName.equals("")) {
            stream.println("package " + fullName.replace('/', '.') + ';');
            if ((type != 3 || entry instanceof TypedefEntry) && !Compile.compiler.importTypes.isEmpty()) {
                stream.println();
                Vector v = Util.addImportLines(entry, Compile.compiler.importTypes, type);
                Util.printImports(v, stream);
            }
        }
    }

    private static void printImports(Vector importList, PrintWriter stream) {
        Enumeration e = importList.elements();
        while (e.hasMoreElements()) {
            stream.println("import " + (String)e.nextElement() + ';');
        }
    }

    private static void addTo(Vector importList, String name) {
        if (name.startsWith("ValueBase") && (name.compareTo("ValueBase") == 0 || name.compareTo("ValueBaseHolder") == 0 || name.compareTo("ValueBaseHelper") == 0)) {
            return;
        }
        if (!importList.contains(name)) {
            importList.addElement(name);
        }
    }

    private static Vector addImportLines(SymtabEntry entry, Vector importTypes, short type) {
        Vector importList = new Vector();
        if (entry instanceof ConstEntry) {
            ConstEntry c = (ConstEntry)entry;
            Object cvalue = c.value().value();
            if (cvalue instanceof ConstEntry && importTypes.contains(cvalue)) {
                Util.addTo(importList, ((ConstEntry)cvalue).name());
            }
        } else if (entry instanceof ValueEntry && type == 2) {
            ValueEntry base;
            String baseName;
            if (((ValueEntry)entry).derivedFrom().size() > 0 && !"ValueBase".equals(baseName = (base = (ValueEntry)((ValueEntry)entry).derivedFrom().elementAt(0)).name()) && importTypes.contains(base)) {
                Util.addTo(importList, baseName + "Helper");
            }
        } else if (entry instanceof InterfaceEntry && (type == 0 || type == 1)) {
            Enumeration en;
            Vector subImportList;
            SymtabEntry parent;
            Enumeration e;
            InterfaceEntry i = (InterfaceEntry)entry;
            if (i instanceof ValueEntry) {
                e = ((ValueEntry)i).supports().elements();
                while (e.hasMoreElements()) {
                    parent = (SymtabEntry)e.nextElement();
                    if (importTypes.contains(parent)) {
                        Util.addTo(importList, parent.name() + "Operations");
                    }
                    if (type != 1) continue;
                    if (importTypes.contains(parent)) {
                        Util.addTo(importList, parent.name());
                    }
                    subImportList = Util.addImportLines(parent, importTypes, (short)1);
                    en = subImportList.elements();
                    while (en.hasMoreElements()) {
                        Util.addTo(importList, (String)en.nextElement());
                    }
                }
            }
            e = i.derivedFrom().elements();
            while (e.hasMoreElements()) {
                parent = (SymtabEntry)e.nextElement();
                if (importTypes.contains(parent)) {
                    Util.addTo(importList, parent.name());
                    if (!(parent instanceof ValueEntry)) {
                        Util.addTo(importList, parent.name() + "Operations");
                    }
                }
                if (type != 1) continue;
                subImportList = Util.addImportLines(parent, importTypes, (short)1);
                en = subImportList.elements();
                while (en.hasMoreElements()) {
                    Util.addTo(importList, (String)en.nextElement());
                }
            }
            e = i.methods().elements();
            while (e.hasMoreElements()) {
                MethodEntry m = (MethodEntry)e.nextElement();
                SymtabEntry mtype = Util.typeOf(m.type());
                if (mtype != null && importTypes.contains(mtype) && (type == 0 || type == 1)) {
                    Util.addTo(importList, mtype.name());
                    Util.addTo(importList, mtype.name() + "Holder");
                    if (type == 1) {
                        Util.addTo(importList, mtype.name() + "Helper");
                    }
                }
                Util.checkForArrays(mtype, importTypes, importList);
                if (type == 1) {
                    Util.checkForBounds(mtype, importTypes, importList);
                }
                Enumeration exEnum = m.exceptions().elements();
                while (exEnum.hasMoreElements()) {
                    ExceptionEntry ex = (ExceptionEntry)exEnum.nextElement();
                    if (!importTypes.contains(ex)) continue;
                    Util.addTo(importList, ex.name());
                    Util.addTo(importList, ex.name() + "Helper");
                }
                Enumeration parms = m.parameters().elements();
                while (parms.hasMoreElements()) {
                    ParameterEntry parm = (ParameterEntry)parms.nextElement();
                    SymtabEntry parmType = Util.typeOf(parm.type());
                    if (importTypes.contains(parmType)) {
                        if (type == 1) {
                            Util.addTo(importList, parmType.name() + "Helper");
                        }
                        if (parm.passType() == 0) {
                            Util.addTo(importList, parmType.name());
                        } else {
                            Util.addTo(importList, parmType.name() + "Holder");
                        }
                    }
                    Util.checkForArrays(parmType, importTypes, importList);
                    if (type != 1) continue;
                    Util.checkForBounds(parmType, importTypes, importList);
                }
            }
        } else if (entry instanceof StructEntry) {
            StructEntry s = (StructEntry)entry;
            Enumeration members = s.members().elements();
            while (members.hasMoreElements()) {
                SymtabEntry member = (TypedefEntry)members.nextElement();
                SymtabEntry memberType = member.type();
                if (importTypes.contains(member = Util.typeOf(member))) {
                    if (!(member instanceof TypedefEntry) && !(member instanceof ValueBoxEntry)) {
                        Util.addTo(importList, member.name());
                    }
                    if (type == 2) {
                        Util.addTo(importList, member.name() + "Helper");
                        if (memberType instanceof TypedefEntry) {
                            Util.addTo(importList, memberType.name() + "Helper");
                        }
                    }
                }
                Util.checkForArrays(member, importTypes, importList);
                Util.checkForBounds(member, importTypes, importList);
            }
        } else if (entry instanceof TypedefEntry) {
            TypedefEntry t = (TypedefEntry)entry;
            String arrays = Util.checkForArrayBase(t, importTypes, importList);
            if (type == 2) {
                Util.checkForArrayDimensions(arrays, importTypes, importList);
                try {
                    SymtabEntry typeEntry;
                    String name = (String)t.dynamicVariable(Compile.typedefInfo);
                    int index = name.indexOf(91);
                    if (index >= 0) {
                        name = name.substring(0, index);
                    }
                    if ((typeEntry = (SymtabEntry)symbolTable.get(name)) != null && importTypes.contains(typeEntry)) {
                        Util.addTo(importList, typeEntry.name() + "Helper");
                    }
                }
                catch (NoSuchFieldException name) {
                    // empty catch block
                }
                Util.checkForBounds(Util.typeOf(t), importTypes, importList);
            }
            Vector subImportList = Util.addImportLines(t.type(), importTypes, type);
            Enumeration e = subImportList.elements();
            while (e.hasMoreElements()) {
                Util.addTo(importList, (String)e.nextElement());
            }
        } else if (entry instanceof UnionEntry) {
            UnionEntry u = (UnionEntry)entry;
            SymtabEntry utype = Util.typeOf(u.type());
            if (utype instanceof EnumEntry && importTypes.contains(utype)) {
                Util.addTo(importList, utype.name());
            }
            Enumeration branches = u.branches().elements();
            while (branches.hasMoreElements()) {
                UnionBranch branch = (UnionBranch)branches.nextElement();
                SymtabEntry branchEntry = Util.typeOf(branch.typedef);
                if (importTypes.contains(branchEntry)) {
                    Util.addTo(importList, branchEntry.name());
                    if (type == 2) {
                        Util.addTo(importList, branchEntry.name() + "Helper");
                    }
                }
                Util.checkForArrays(branchEntry, importTypes, importList);
                Util.checkForBounds(branchEntry, importTypes, importList);
            }
        }
        Enumeration en = importList.elements();
        while (en.hasMoreElements()) {
            TypedefEntry t;
            String name = (String)en.nextElement();
            SymtabEntry e = (SymtabEntry)symbolTable.get(name);
            if (e == null || !(e instanceof TypedefEntry) || (t = (TypedefEntry)e).arrayInfo().size() != 0 && t.type() instanceof SequenceEntry) continue;
            importList.removeElement(name);
        }
        return importList;
    }

    private static void checkForArrays(SymtabEntry entry, Vector importTypes, Vector importList) {
        if (entry instanceof TypedefEntry) {
            TypedefEntry t = (TypedefEntry)entry;
            String arrays = Util.checkForArrayBase(t, importTypes, importList);
            Util.checkForArrayDimensions(arrays, importTypes, importList);
        }
    }

    private static String checkForArrayBase(TypedefEntry t, Vector importTypes, Vector importList) {
        String arrays = "";
        try {
            SymtabEntry typeEntry;
            String name = (String)t.dynamicVariable(Compile.typedefInfo);
            int index = name.indexOf(91);
            if (index >= 0) {
                arrays = name.substring(index);
                name = name.substring(0, index);
            }
            if ((typeEntry = (SymtabEntry)symbolTable.get(name)) != null && importTypes.contains(typeEntry)) {
                Util.addTo(importList, typeEntry.name());
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return arrays;
    }

    private static void checkForArrayDimensions(String arrays, Vector importTypes, Vector importList) {
        while (!arrays.equals("")) {
            int i;
            int index = arrays.indexOf(93);
            String dim = arrays.substring(1, index);
            arrays = arrays.substring(index + 1);
            SymtabEntry constant = (SymtabEntry)symbolTable.get(dim);
            if (constant == null && (i = dim.lastIndexOf(46)) >= 0) {
                constant = (SymtabEntry)symbolTable.get(dim.substring(0, i));
            }
            if (constant == null || !importTypes.contains(constant)) continue;
            Util.addTo(importList, constant.name());
        }
    }

    private static void checkForBounds(SymtabEntry entry, Vector importTypes, Vector importList) {
        SymtabEntry entryType = entry;
        while (entryType instanceof TypedefEntry) {
            entryType = entryType.type();
        }
        if (entryType instanceof StringEntry && ((StringEntry)entryType).maxSize() != null) {
            Util.checkForGlobalConstants(((StringEntry)entryType).maxSize().rep(), importTypes, importList);
        } else if (entryType instanceof SequenceEntry && ((SequenceEntry)entryType).maxSize() != null) {
            Util.checkForGlobalConstants(((SequenceEntry)entryType).maxSize().rep(), importTypes, importList);
        }
    }

    private static void checkForGlobalConstants(String exprRep, Vector importTypes, Vector importList) {
        StringTokenizer st = new StringTokenizer(exprRep, " +-*()~&|^%<>");
        while (st.hasMoreTokens()) {
            SymtabEntry typeEntry;
            String token = st.nextToken();
            if (token.equals("/") || !((typeEntry = (SymtabEntry)symbolTable.get(token)) instanceof ConstEntry)) continue;
            int slashIdx = token.indexOf(47);
            if (slashIdx < 0) {
                if (!importTypes.contains(typeEntry)) continue;
                Util.addTo(importList, typeEntry.name());
                continue;
            }
            SymtabEntry constContainer = (SymtabEntry)symbolTable.get(token.substring(0, slashIdx));
            if (!(constContainer instanceof InterfaceEntry) || !importTypes.contains(constContainer)) continue;
            Util.addTo(importList, constContainer.name());
        }
    }

    public static void writeInitializer(String indent, String name, String arrayDcl, SymtabEntry entry, PrintWriter stream) {
        if (entry instanceof TypedefEntry) {
            TypedefEntry td = (TypedefEntry)entry;
            Util.writeInitializer(indent, name, arrayDcl + Util.sansArrayInfo(td.arrayInfo()), td.type(), stream);
        } else if (entry instanceof SequenceEntry) {
            Util.writeInitializer(indent, name, arrayDcl + "[]", entry.type(), stream);
        } else if (entry instanceof EnumEntry) {
            if (arrayDcl.length() > 0) {
                stream.println(indent + Util.javaName(entry) + ' ' + name + arrayDcl + " = null;");
            } else {
                stream.println(indent + Util.javaName(entry) + ' ' + name + " = null;");
            }
        } else if (entry instanceof PrimitiveEntry) {
            boolean array = arrayDcl.length() > 0;
            String tname = Util.javaPrimName(entry.name());
            if (tname.equals("boolean")) {
                stream.println(indent + "boolean " + name + arrayDcl + " = " + (array ? "null;" : "false;"));
            } else if (tname.equals("org.omg.CORBA.TypeCode")) {
                stream.println(indent + "org.omg.CORBA.TypeCode " + name + arrayDcl + " = null;");
            } else if (tname.equals("org.omg.CORBA.Any")) {
                stream.println(indent + "org.omg.CORBA.Any " + name + arrayDcl + " = null;");
            } else if (tname.equals("org.omg.CORBA.Principal")) {
                stream.println(indent + "org.omg.CORBA.Principal " + name + arrayDcl + " = null;");
            } else {
                stream.println(indent + tname + ' ' + name + arrayDcl + " = " + (array ? "null;" : '(' + tname + ")0;"));
            }
        } else {
            stream.println(indent + Util.javaName(entry) + ' ' + name + arrayDcl + " = null;");
        }
    }

    public static void writeInitializer(String indent, String name, String arrayDcl, SymtabEntry entry, String initializer, PrintWriter stream) {
        if (entry instanceof TypedefEntry) {
            TypedefEntry td = (TypedefEntry)entry;
            Util.writeInitializer(indent, name, arrayDcl + Util.sansArrayInfo(td.arrayInfo()), td.type(), initializer, stream);
        } else if (entry instanceof SequenceEntry) {
            Util.writeInitializer(indent, name, arrayDcl + "[]", entry.type(), initializer, stream);
        } else if (entry instanceof EnumEntry) {
            if (arrayDcl.length() > 0) {
                stream.println(indent + Util.javaName(entry) + ' ' + name + arrayDcl + " = " + initializer + ';');
            } else {
                stream.println(indent + Util.javaName(entry) + ' ' + name + " = " + initializer + ';');
            }
        } else if (entry instanceof PrimitiveEntry) {
            boolean array = arrayDcl.length() > 0;
            String tname = Util.javaPrimName(entry.name());
            if (tname.equals("boolean")) {
                stream.println(indent + "boolean " + name + arrayDcl + " = " + initializer + ';');
            } else if (tname.equals("org.omg.CORBA.TypeCode")) {
                stream.println(indent + "org.omg.CORBA.TypeCode " + name + arrayDcl + " = " + initializer + ';');
            } else if (tname.equals("org.omg.CORBA.Any")) {
                stream.println(indent + "org.omg.CORBA.Any " + name + arrayDcl + " = " + initializer + ';');
            } else if (tname.equals("org.omg.CORBA.Principal")) {
                stream.println(indent + "org.omg.CORBA.Principal " + name + arrayDcl + " = " + initializer + ';');
            } else {
                stream.println(indent + tname + ' ' + name + arrayDcl + " = " + initializer + ';');
            }
        } else {
            stream.println(indent + Util.javaName(entry) + ' ' + name + arrayDcl + " = " + initializer + ';');
        }
    }

    public static void mkdir(String name) {
        String targetDir = ((Arguments)Compile.compiler.arguments).targetDir;
        name = (targetDir + name).replace('/', File.separatorChar);
        File pkg = new File(name);
        if (!pkg.exists() && !pkg.mkdirs()) {
            System.err.println(Util.getMessage("Util.cantCreatePkg", name));
        }
    }

    public static void writeProlog(PrintWriter stream, String filename) {
        String targetDir = ((Arguments)Compile.compiler.arguments).targetDir;
        if (targetDir != null) {
            filename = filename.substring(targetDir.length());
        }
        stream.println();
        stream.println("/**");
        stream.println("* " + filename.replace(File.separatorChar, '/') + " .");
        stream.println("* " + Util.getMessage("toJavaProlog1", Util.getMessage("Version.product", Util.getMessage("Version.number"))));
        stream.println("* " + Util.getMessage("toJavaProlog2", Compile.compiler.arguments.file.replace(File.separatorChar, '/')));
        DateFormat formatter = DateFormat.getDateTimeInstance(0, 0, Locale.getDefault());
        if (Locale.getDefault() == Locale.JAPAN) {
            formatter.setTimeZone(TimeZone.getTimeZone("JST"));
        } else {
            formatter.setTimeZone(TimeZone.getDefault());
        }
        stream.println("* " + formatter.format(new Date()));
        stream.println("*/");
        stream.println();
    }

    public static String stripLeadingUnderscores(String string) {
        while (string.startsWith("_")) {
            string = string.substring(1);
        }
        return string;
    }

    public static String stripLeadingUnderscoresFromID(String string) {
        String stringPrefix = "";
        int slashIndex = string.indexOf(58);
        if (slashIndex >= 0) {
            do {
                stringPrefix = stringPrefix + string.substring(0, slashIndex + 1);
                string = string.substring(slashIndex + 1);
                while (string.startsWith("_")) {
                    string = string.substring(1);
                }
            } while ((slashIndex = string.indexOf(47)) >= 0);
        }
        return stringPrefix + string;
    }

    public static String parseExpression(Expression e) {
        if (e instanceof Terminal) {
            return Util.parseTerminal((Terminal)e);
        }
        if (e instanceof BinaryExpr) {
            return Util.parseBinary((BinaryExpr)e);
        }
        if (e instanceof UnaryExpr) {
            return Util.parseUnary((UnaryExpr)e);
        }
        return "(UNKNOWN_VALUE)";
    }

    static String parseTerminal(Terminal e) {
        if (e.value() instanceof ConstEntry) {
            ConstEntry c = (ConstEntry)e.value();
            if (c.container() instanceof InterfaceEntry) {
                return Util.javaQualifiedName(c.container()) + '.' + c.name();
            }
            return Util.javaQualifiedName(c) + ".value";
        }
        if (e.value() instanceof Expression) {
            return '(' + Util.parseExpression((Expression)e.value()) + ')';
        }
        if (e.value() instanceof Character) {
            if (((Character)e.value()).charValue() == '\u000b') {
                return "'\\013'";
            }
            if (((Character)e.value()).charValue() == '\u0007') {
                return "'\\007'";
            }
            if (e.rep().startsWith("'\\x")) {
                return Util.hexToOctal(e.rep());
            }
            if (e.rep().equals("'\\?'")) {
                return "'?'";
            }
            return e.rep();
        }
        if (e.value() instanceof Boolean) {
            return e.value().toString();
        }
        if (e.value() instanceof BigInteger) {
            SymtabEntry typeEntry = (SymtabEntry)symbolTable.get(e.type());
            while (typeEntry.type() != null) {
                typeEntry = typeEntry.type();
            }
            String type = typeEntry.name();
            if (type.equals("unsigned long long") && ((BigInteger)e.value()).compareTo(Expression.llMax) > 0) {
                BigInteger v = (BigInteger)e.value();
                v = v.subtract(Expression.twoPow64);
                int index = e.rep().indexOf(41);
                if (index < 0) {
                    return v.toString() + 'L';
                }
                return '(' + v.toString() + 'L' + ')';
            }
            if (type.indexOf("long long") >= 0 || type.equals("unsigned long")) {
                String rep = e.rep();
                int index = rep.indexOf(41);
                if (index < 0) {
                    return rep + 'L';
                }
                return rep.substring(0, index) + 'L' + rep.substring(index);
            }
            return e.rep();
        }
        return e.rep();
    }

    static String hexToOctal(String hex) {
        hex = hex.substring(3, hex.length() - 1);
        return "'\\" + Integer.toString(Integer.parseInt(hex, 16), 8) + "'";
    }

    static String parseBinary(BinaryExpr e) {
        String castString = "";
        if (e.value() instanceof Float || e.value() instanceof Double) {
            castString = "(double)";
            if (!(e instanceof Plus || e instanceof Minus || e instanceof Times || e instanceof Divide)) {
                System.err.println("Operator " + e.op() + " is invalid on floating point numbers");
            }
        } else if (e.value() instanceof Number) {
            castString = e.type().indexOf("long long") >= 0 ? "(long)" : "(int)";
        } else {
            castString = "";
            System.err.println("Unknown type in constant expression");
        }
        if (e.type().equals("unsigned long long")) {
            BigInteger value = (BigInteger)e.value();
            if (value.compareTo(Expression.llMax) > 0) {
                value = value.subtract(Expression.twoPow64);
            }
            return castString + '(' + value.toString() + 'L' + ')';
        }
        return castString + '(' + Util.parseExpression(e.left()) + ' ' + e.op() + ' ' + Util.parseExpression(e.right()) + ')';
    }

    static String parseUnary(UnaryExpr e) {
        if (!(e.value() instanceof Number)) {
            return "(UNKNOWN_VALUE)";
        }
        if ((e.value() instanceof Float || e.value() instanceof Double) && e instanceof Not) {
            return "(UNKNOWN_VALUE)";
        }
        String castString = "";
        castString = e.operand().value() instanceof Float || e.operand().value() instanceof Double ? "(double)" : (e.type().indexOf("long long") >= 0 ? "(long)" : "(int)");
        if (e.type().equals("unsigned long long")) {
            BigInteger value = (BigInteger)e.value();
            if (value.compareTo(Expression.llMax) > 0) {
                value = value.subtract(Expression.twoPow64);
            }
            return castString + '(' + value.toString() + 'L' + ')';
        }
        return castString + e.op() + Util.parseExpression(e.operand());
    }

    public static boolean IDLEntity(SymtabEntry entry) {
        boolean rc = true;
        if (entry instanceof PrimitiveEntry || entry instanceof StringEntry) {
            rc = false;
        } else if (entry instanceof TypedefEntry) {
            rc = Util.IDLEntity(entry.type());
        }
        return rc;
    }

    public static boolean corbaLevel(float min, float max) {
        float level = Compile.compiler.arguments.corbaLevel;
        float delta = 0.001f;
        return level - min + delta >= 0.0f && max - level + delta >= 0.0f;
    }
}

