/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.client.impl.ActiveMQXAResource;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnection;

public class ActiveMQRAXAResource
implements ActiveMQXAResource {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    private final ActiveMQRAManagedConnection managedConnection;
    private final XAResource xaResource;

    public ActiveMQRAXAResource(ActiveMQRAManagedConnection managedConnection, XAResource xaResource) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + managedConnection + ", " + xaResource + ")");
        }
        this.managedConnection = managedConnection;
        this.xaResource = xaResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("start(" + xid + ", " + flags + ")");
        }
        this.managedConnection.lock();
        ClientSessionInternal sessionInternal = (ClientSessionInternal)this.xaResource;
        try {
            try {
                sessionInternal.resetIfNeeded();
            }
            catch (ActiveMQException e) {
                ActiveMQRALogger.LOGGER.problemResettingXASession(e);
                XAException xaException = new XAException(-7);
                xaException.initCause(e);
                throw xaException;
            }
            this.xaResource.start(xid, flags);
        }
        finally {
            this.managedConnection.setInManagedTx(true);
            this.managedConnection.unlock();
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("end(" + xid + ", " + flags + ")");
        }
        this.managedConnection.lock();
        try {
            this.xaResource.end(xid, flags);
        }
        finally {
            this.managedConnection.setInManagedTx(false);
            this.managedConnection.unlock();
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("prepare(" + xid + ")");
        }
        return this.xaResource.prepare(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("commit(" + xid + ", " + onePhase + ")");
        }
        this.xaResource.commit(xid, onePhase);
    }

    public void rollback(Xid xid) throws XAException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("rollback(" + xid + ")");
        }
        this.xaResource.rollback(xid);
    }

    public void forget(Xid xid) throws XAException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("forget(" + xid + ")");
        }
        this.managedConnection.lock();
        try {
            this.xaResource.forget(xid);
        }
        finally {
            this.managedConnection.setInManagedTx(true);
            this.managedConnection.setInManagedTx(false);
            this.managedConnection.unlock();
        }
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isSameRM(" + xaRes + ")");
        }
        return this.xaResource.isSameRM(xaRes);
    }

    public Xid[] recover(int flag) throws XAException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("recover(" + flag + ")");
        }
        return this.xaResource.recover(flag);
    }

    public int getTransactionTimeout() throws XAException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getTransactionTimeout()");
        }
        return this.xaResource.getTransactionTimeout();
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setTransactionTimeout(" + seconds + ")");
        }
        return this.xaResource.setTransactionTimeout(seconds);
    }

    public XAResource getResource() {
        return this.xaResource;
    }
}

