/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.container.AeshCommandContainer;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedCommandBuilder;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.impl.parser.AeshCommandLineParser;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.result.ResultHandler;
import org.aesh.command.validator.CommandValidator;
import org.aesh.util.ReflectionUtil;

public class CommandBuilder {
    private String name;
    private String description;
    private Command command;
    private CommandValidator<Command> validator;
    private ResultHandler resultHandler;
    private ProcessedOption argument;
    private List<ProcessedOption> options;
    private List<CommandBuilder> children;
    private CommandLineParserException parserException;
    private CommandPopulator<Object, Command> populator;
    private List<String> aliases;

    public CommandBuilder name(String name) {
        this.name = name;
        return this;
    }

    public CommandBuilder aliases(List<String> aliases) {
        this.aliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(aliases);
        return this;
    }

    public CommandBuilder description(String description) {
        this.description = description;
        return this;
    }

    public CommandBuilder command(Command command) {
        this.command = command;
        return this;
    }

    public CommandBuilder command(Class<? extends Command> command) {
        this.command = ReflectionUtil.newInstance(command);
        return this;
    }

    public CommandBuilder validator(CommandValidator<Command> commandValidator) {
        this.validator = commandValidator;
        return this;
    }

    public CommandBuilder validator(Class<CommandValidator<Command>> commandValidator) {
        this.validator = ReflectionUtil.newInstance(commandValidator);
        return this;
    }

    public CommandBuilder populator(CommandPopulator<Object, Command> populator) {
        this.populator = populator;
        return this;
    }

    public CommandBuilder resultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public CommandBuilder resultHandler(Class<ResultHandler> resultHandler) {
        this.resultHandler = ReflectionUtil.newInstance(resultHandler);
        return this;
    }

    public CommandBuilder argument(ProcessedOption argument) {
        this.argument = argument;
        return this;
    }

    public CommandBuilder addOption(ProcessedOption option) {
        if (this.options == null) {
            this.options = new ArrayList<ProcessedOption>();
        }
        this.options.add(option);
        return this;
    }

    public CommandBuilder addOption(ProcessedOptionBuilder option) {
        if (this.options == null) {
            this.options = new ArrayList<ProcessedOption>();
        }
        try {
            this.options.add(option.build());
        }
        catch (OptionParserException ope) {
            this.parserException = ope;
        }
        return this;
    }

    public CommandBuilder addOptions(List<ProcessedOption> options) {
        if (this.options == null) {
            this.options = new ArrayList<ProcessedOption>();
        }
        this.options.addAll(options);
        return this;
    }

    public CommandBuilder addChild(CommandBuilder child) {
        if (this.children == null) {
            this.children = new ArrayList<CommandBuilder>();
        }
        this.children.add(child);
        return this;
    }

    public CommandBuilder addChildren(List<CommandBuilder> children) {
        if (this.children == null) {
            this.children = new ArrayList<CommandBuilder>();
        }
        this.children.addAll(children);
        return this;
    }

    public CommandContainer create() {
        try {
            if (this.parserException != null) {
                return new AeshCommandContainer(this.parserException.getMessage());
            }
            return new AeshCommandContainer(this.createParser());
        }
        catch (CommandLineParserException e) {
            return new AeshCommandContainer(e.getMessage());
        }
    }

    private AeshCommandLineParser<Command> createParser() throws CommandLineParserException {
        if (this.command == null) {
            throw new CommandLineParserException("Command object is null, cannot build command");
        }
        ProcessedCommand<Command> processedCommand = this.createProcessedCommand();
        AeshCommandLineParser<Command> parser = new AeshCommandLineParser<Command>(processedCommand);
        if (this.children != null) {
            for (CommandBuilder builder : this.children) {
                parser.addChildParser(builder.createParser());
            }
        }
        return parser;
    }

    private ProcessedCommand<Command> createProcessedCommand() throws CommandLineParserException {
        return new ProcessedCommandBuilder().name(this.name).aliases(this.aliases).command(this.command).description(this.description).addOptions(this.options).resultHandler(this.resultHandler).validator(this.validator).arguments(this.argument).populator(this.populator).create();
    }
}

