/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.deployment;

import java.io.IOException;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.LegacyBridge;
import org.jboss.as.cli.impl.aesh.cmd.deployment.AbstractDeployCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DeploymentCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.AccessRequirements;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.OptionActivators;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.Permissions;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.cli.command.aesh.activator.HideOptionActivator;

@CommandDefinition(name="deployment-deploy-content", description="")
public abstract class AbstractDeployContentCommand
extends AbstractDeployCommand
implements LegacyBridge {
    @Deprecated
    @Option(hasValue=false, activator=HideOptionActivator.class)
    private boolean help;
    @Option(hasValue=false, required=false, activator=OptionActivators.ReplaceActivator.class, shortName=114)
    public boolean replace;
    @Option(hasValue=false, required=false, activator=OptionActivators.DisabledActivator.class)
    public boolean disabled;
    @Option(hasValue=false, required=false, activator=OptionActivators.EnabledActivator.class)
    public boolean enabled;
    @Option(hasValue=true, name="runtime-name", required=false, activator=OptionActivators.RuntimeNameActivator.class)
    public String runtimeName;
    private final String legacyReplaceName;

    AbstractDeployContentCommand(CommandContext ctx, Permissions permissions) {
        super(ctx, AccessRequirements.deployContentAccess(permissions), permissions);
        this.legacyReplaceName = null;
    }

    AbstractDeployContentCommand(CommandContext ctx, Permissions permissions, String legacyReplaceName) {
        super(ctx, AccessRequirements.deployContentAccess(permissions), permissions);
        this.legacyReplaceName = legacyReplaceName;
    }

    protected abstract void checkArgument() throws CommandException;

    protected abstract String getCommandName();

    private String getReplaceOptionName() {
        return this.legacyReplaceName == null ? "--replace" : "--" + this.legacyReplaceName;
    }

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo("deploy " + this.getCommandName()));
            return CommandResult.SUCCESS;
        }
        return this.execute(commandInvocation.getCommandContext());
    }

    @Override
    public CommandResult execute(CommandContext ctx) throws CommandException {
        this.checkArgument();
        try {
            ModelNode request = this.buildRequest(ctx);
            ModelNode result = this.execute(ctx, request);
            if (!Util.isSuccess(result)) {
                throw new CommandException(Util.getFailureDescription(result));
            }
        }
        catch (IOException e) {
            throw new CommandException("Failed to deploy", e);
        }
        catch (CommandFormatException ex) {
            throw new CommandException(ex);
        }
        return CommandResult.SUCCESS;
    }

    protected abstract ModelNode execute(CommandContext var1, ModelNode var2) throws IOException;

    protected ModelNode buildDeploymentRequest(CommandContext ctx, String op) throws OperationFormatException {
        return this.buildDeploymentRequest(ctx, op, this.getName(), this.runtimeName, false);
    }

    private ModelNode buildDeploymentRequest(CommandContext ctx, String op, String name, String runtimeName, boolean addHeaders) throws OperationFormatException {
        ModelNode request = new ModelNode();
        request.get("operation").set(op);
        request.get("name").set(name);
        if (op.equals("add")) {
            request.get("address", "deployment").set(name);
        }
        if (runtimeName != null) {
            request.get("runtime-name").set(runtimeName);
        }
        ModelNode content = request.get("content").get(0);
        this.addContent(ctx, content);
        if (addHeaders && this.headers != null) {
            ModelNode opHeaders = request.get("operation-headers");
            opHeaders.set(this.headers);
        }
        return request;
    }

    protected abstract void addContent(CommandContext var1, ModelNode var2) throws OperationFormatException;

    protected abstract String getName();

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        try {
            this.checkArgument();
        }
        catch (CommandException ex) {
            throw new CommandFormatException(ex);
        }
        CommandContext ctx = context;
        String name = this.getName();
        Boolean disable = null;
        if (this.disabled) {
            disable = true;
        } else if (this.enabled) {
            disable = false;
        }
        if (this.replace) {
            if ((this.disabled || this.enabled) && ctx.isDomainMode() || this.serverGroups != null || this.allServerGroups) {
                throw new CommandFormatException("--" + this.getReplaceOptionName() + " only replaces the content in the deployment repository and can't be used in combination with any of --enabled, --disabled, --server-groups or --all-server-groups.");
            }
            if (Util.isDeploymentInRepository(name, ctx.getModelControllerClient())) {
                ModelNode request = this.buildDeploymentRequest(ctx, "full-replace-deployment", name, this.runtimeName, true);
                if (disable != null) {
                    request.get("enabled").set(disable == false);
                }
                return request;
            }
            if (ctx.isDomainMode()) {
                ModelNode request = this.buildDeploymentRequest(ctx, "add", name, this.runtimeName, true);
                return request;
            }
        }
        if (this.disabled) {
            if (this.serverGroups != null || this.allServerGroups) {
                throw new CommandFormatException("--server-groups and --all-server-groups can't be used in combination with --disabled.");
            }
            if (!ctx.isBatchMode() && Util.isDeploymentInRepository(name, ctx.getModelControllerClient())) {
                throw new CommandFormatException("'" + name + "' already exists in the deployment repository (use  " + this.getReplaceOptionName() + " to replace the existing content in the repository).");
            }
            ModelNode request = this.buildDeploymentRequest(ctx, "add", name, this.runtimeName, true);
            return request;
        }
        ModelNode deployRequest = new ModelNode();
        if (ctx.isDomainMode()) {
            List<String> sgList = this.getServerGroups(ctx);
            deployRequest.get("operation").set("composite");
            deployRequest.get("address").setEmptyList();
            ModelNode steps = deployRequest.get("steps");
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("add", name, serverGroup));
            }
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("deploy", name, serverGroup));
            }
        } else {
            if (this.serverGroups != null || this.allServerGroups) {
                throw new CommandFormatException("--all-server-groups and --server-groups can't appear in standalone mode.");
            }
            deployRequest.get("operation").set("deploy");
            deployRequest.get("address", "deployment").set(name);
        }
        ModelNode compositeStep = this.createExtraStep(ctx);
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        steps.add(compositeStep);
        steps.add(deployRequest);
        if (this.headers != null) {
            ModelNode opHeaders = composite.get("operation-headers");
            opHeaders.set(this.headers);
        }
        return composite;
    }

    protected List<String> getServerGroups(CommandContext ctx) throws CommandFormatException {
        return DeploymentCommand.getServerGroups(ctx, ctx.getModelControllerClient(), this.allServerGroups, this.serverGroups, null);
    }

    protected ModelNode createExtraStep(CommandContext ctx) throws CommandFormatException {
        if (!ctx.isBatchMode() && Util.isDeploymentInRepository(this.getName(), ctx.getModelControllerClient())) {
            throw new CommandFormatException("'" + this.getName() + "' already exists in the deployment repository (use " + this.getReplaceOptionName() + " to replace the existing content in the repository).");
        }
        ModelNode request = this.buildDeploymentRequest(ctx, "add");
        request.get("address", "deployment").set(this.getName());
        if (ctx.isDomainMode()) {
            request.get("enabled").set(true);
        }
        return request;
    }
}

