/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.security.Permission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.wildfly.security.permission.AbstractPermission;
import org.wildfly.security.permission.AbstractPermissionCollection;
import org.wildfly.security.permission.PermissionUtil;

public final class ByNamePermissionCollection
extends AbstractPermissionCollection {
    private final ConcurrentHashMap<String, Permission> byName = new ConcurrentHashMap();
    private volatile Permission all;

    public ByNamePermissionCollection(AbstractPermission<?> sourcePermission) {
        super(sourcePermission);
    }

    @Override
    public int size() {
        return this.all != null ? 1 : this.byName.size();
    }

    @Override
    public Iterator<Permission> iterator() {
        return this.getIterablePermissions().iterator();
    }

    @Override
    public Enumeration<Permission> elements() {
        return Collections.enumeration(this.getIterablePermissions());
    }

    private Collection<Permission> getIterablePermissions() {
        return this.all != null ? Collections.singleton(this.all) : Arrays.asList(this.byName.values().toArray(PermissionUtil.NO_PERMISSIONS));
    }

    @Override
    protected void doAdd(AbstractPermission<?> permission) {
        if (permission.getName().equals("*")) {
            this.all = permission;
            this.byName.clear();
        } else {
            this.byName.putIfAbsent(permission.getName(), permission);
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null || this.getSourcePermission().getClass() != permission.getClass()) {
            return false;
        }
        Permission all = this.all;
        if (all != null) {
            return all.implies(permission);
        }
        Permission ourPermission = this.byName.get(permission.getName());
        return ourPermission != null && ourPermission.implies(permission);
    }
}

