/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class DeploymentTable
extends JTable {
    private boolean isStandalone;

    public DeploymentTable(TableModel dm, boolean isStandalone) {
        super(dm);
        this.isStandalone = isStandalone;
        this.setRowHeight(30);
        this.setAutoCreateRowSorter(true);
        this.setDefaultRenderer(String.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = new JLabel((String)value);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)label, "Center");
                return panel;
            }
        });
        this.setDefaultRenderer(JRadioButton.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return (JRadioButton)value;
            }
        });
        this.setDefaultRenderer(List.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                List values = (List)value;
                return new JComboBox(new Vector(values));
            }
        });
        this.setDefaultEditor(JRadioButton.class, new RadioButtonEditor(new JCheckBox()));
        this.setDefaultEditor(List.class, new ComboBoxEditor());
        this.setSelectionMode(0);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(700, 200);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return true;
        }
        return column == 2 && !this.isStandalone;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        super.editingStopped(e);
        this.repaint();
    }

    class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        private JRadioButton button;

        public RadioButtonEditor(JCheckBox checkBox) {
            super(checkBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            this.button = (JRadioButton)value;
            this.button.addItemListener(this);
            return (Component)value;
        }

        @Override
        public Object getCellEditorValue() {
            this.button.removeItemListener(this);
            return this.button;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            super.fireEditingStopped();
        }
    }

    class ComboBoxEditor
    extends DefaultCellEditor {
        ComboBoxEditor() {
            super(new JComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return new JComboBox(new Vector((List)value));
        }
    }
}

