/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.UnaryRequirementAliasBuilder;
import org.jboss.as.clustering.controller.UnaryServiceNameFactory;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.GroupAliasBuilderProvider;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class GroupRequirementAliasBuilderProvider
implements GroupAliasBuilderProvider {
    private final ClusteringRequirement requirement;
    private final Function<String, JndiName> jndiNameFactory;

    protected GroupRequirementAliasBuilderProvider(ClusteringRequirement requirement) {
        this(requirement, null);
    }

    protected GroupRequirementAliasBuilderProvider(ClusteringRequirement requirement, Function<String, JndiName> jndiNameFactory) {
        this.requirement = requirement;
        this.jndiNameFactory = jndiNameFactory;
    }

    public Collection<CapabilityServiceBuilder<?>> getBuilders(ServiceNameRegistry<ClusteringRequirement> registry, String aliasGroup, String targetGroup) {
        UnaryRequirementAliasBuilder builder = new UnaryRequirementAliasBuilder(registry.getServiceName((Requirement)this.requirement), (UnaryServiceNameFactory)this.requirement, targetGroup, this.requirement.getType());
        if (this.jndiNameFactory == null || "default".equals(targetGroup)) {
            return Collections.singleton(builder);
        }
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply(aliasGroup).getAbsoluteName());
        BinderServiceBuilder binderBuilder = new BinderServiceBuilder(binding, builder.getServiceName(), this.requirement.getType());
        return Arrays.asList(builder, binderBuilder);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

