/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Map;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.registry.CacheRegistry;
import org.wildfly.clustering.server.registry.CacheRegistryConfiguration;
import org.wildfly.clustering.server.registry.FunctionalRegistryFactory;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class CacheRegistryFactoryBuilder<K, V>
implements CapabilityServiceBuilder<RegistryFactory<K, V>>,
CacheRegistryConfiguration<K, V>,
Value<RegistryFactory<K, V>>,
BiFunction<Map.Entry<K, V>, Runnable, Registry<K, V>> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private volatile ValueDependency<Group<Address>> group;
    private volatile ValueDependency<Cache<Address, Map.Entry<K, V>>> cache;

    public CacheRegistryFactoryBuilder(ServiceName name, String containerName, String cacheName) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public RegistryFactory<K, V> getValue() {
        return new FunctionalRegistryFactory(this);
    }

    @Override
    public Registry<K, V> apply(Map.Entry<K, V> entry, Runnable closeTask) {
        return new CacheRegistry<K, V>(this, entry, closeTask);
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<RegistryFactory<K, V>> configure(CapabilityServiceSupport support) {
        this.cache = new InjectedValueDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.containerName, this.cacheName), Cache.class);
        this.group = new InjectedValueDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.cacheName), Group.class);
        return this;
    }

    public ServiceBuilder<RegistryFactory<K, V>> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.name, (Service)new ValueService((Value)this)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        return new CompositeDependency(new Dependency[]{this.cache, this.group}).register(builder);
    }

    @Override
    public Batcher<? extends Batch> getBatcher() {
        return new InfinispanBatcher(this.getCache());
    }

    @Override
    public Group<Address> getGroup() {
        return (Group)this.group.getValue();
    }

    @Override
    public Cache<Address, Map.Entry<K, V>> getCache() {
        return (Cache)this.cache.getValue();
    }
}

