/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Map;
import java.util.function.BiFunction;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.registry.FunctionalRegistryFactory;
import org.wildfly.clustering.server.registry.LocalRegistry;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class LocalRegistryFactoryBuilder<K, V>
implements CapabilityServiceBuilder<RegistryFactory<K, V>>,
BiFunction<Map.Entry<K, V>, Runnable, Registry<K, V>>,
Value<RegistryFactory<K, V>> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private volatile ValueDependency<Group> group;

    public LocalRegistryFactoryBuilder(ServiceName name, String containerName, String cacheName) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public RegistryFactory<K, V> getValue() {
        return new FunctionalRegistryFactory(this);
    }

    @Override
    public Registry<K, V> apply(Map.Entry<K, V> entry, Runnable closeTask) {
        return new LocalRegistry<K, V>((Group)this.group.getValue(), entry, closeTask);
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<RegistryFactory<K, V>> configure(CapabilityServiceSupport support) {
        this.group = new InjectedValueDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.cacheName), Group.class);
        return this;
    }

    public ServiceBuilder<RegistryFactory<K, V>> build(ServiceTarget target) {
        return this.group.register(target.addService(this.name, (Service)new ValueService((Value)this)).setInitialMode(ServiceController.Mode.ON_DEMAND));
    }
}

