/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.singleton.PrimaryProxyContext;
import org.wildfly.clustering.server.singleton.SingletonValueCommand;

public class PrimaryProxyService<T>
implements Service<T> {
    private final PrimaryProxyContext<T> context;
    private volatile boolean started = false;

    public PrimaryProxyService(PrimaryProxyContext<T> context) {
        this.context = context;
    }

    public T getValue() {
        if (!this.started) {
            throw ClusteringServerLogger.ROOT_LOGGER.notStarted(this.context.getServiceName().getCanonicalName());
        }
        try {
            Map responses = this.context.getCommandDispatcher().executeOnCluster(new SingletonValueCommand(), new Node[0]);
            HashMap results = new HashMap();
            try {
                for (Map.Entry entry : responses.entrySet()) {
                    Optional response = (Optional)((CommandResponse)entry.getValue()).get();
                    if (response == null) continue;
                    results.put(entry.getKey(), response);
                }
            }
            catch (ExecutionException e) {
                throw new IllegalArgumentException(e);
            }
            if (results.size() > 1) {
                throw ClusteringServerLogger.ROOT_LOGGER.multiplePrimaryProvidersDetected(this.context.getServiceName().getCanonicalName(), results.keySet());
            }
            Iterator values = results.values().iterator();
            if (!values.hasNext()) {
                throw ClusteringServerLogger.ROOT_LOGGER.noResponseFromMaster(this.context.getServiceName().getCanonicalName());
            }
            return ((Optional)values.next()).orElse(null);
        }
        catch (CommandDispatcherException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void start(StartContext context) {
        this.started = true;
    }

    public void stop(StopContext context) {
        this.started = false;
    }
}

