/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.idp;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.picketlink.identity.federation.bindings.wildfly.idp.PicketLinkUndertowPrincipal;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;

public class UndertowRoleGenerator
implements RoleGenerator {
    public List<String> generateRoles(Principal principal) {
        HashSet<String> roles = new HashSet<String>();
        if (principal instanceof PicketLinkUndertowPrincipal) {
            PicketLinkUndertowPrincipal pup = (PicketLinkUndertowPrincipal)principal;
            roles.addAll(pup.getRoles());
        } else {
            roles.addAll(this.fromSubject());
            roles.addAll(this.fromMappedRoles());
        }
        return roles.stream().collect(Collectors.toList());
    }

    private List<String> fromSubject() {
        Set<Group> groups;
        ArrayList<String> roles = new ArrayList<String>();
        Subject subject = SecurityContextAssociation.getSubject();
        if (subject != null && (groups = subject.getPrincipals(Group.class)) != null) {
            for (Group group : groups) {
                if (!"Roles".equals(group.getName())) continue;
                Enumeration subjectRoles = group.members();
                while (subjectRoles.hasMoreElements()) {
                    Principal role = (Principal)subjectRoles.nextElement();
                    roles.add(role.getName());
                }
            }
        }
        return roles;
    }

    private Set<String> fromMappedRoles() {
        Object mappedRoles;
        SecurityContext context = SecurityContextAssociation.getSecurityContext();
        if (context != null && (mappedRoles = context.getData().get("Roles")) instanceof RoleGroup) {
            RoleGroup roleGroup = (RoleGroup)mappedRoles;
            return roleGroup.getRoles().stream().map(Role::getRoleName).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

