/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchImpl;
import org.jboss.as.patching.metadata.RollbackPatch;
import org.jboss.as.patching.metadata.impl.IdentityImpl;
import org.jboss.as.patching.runner.IdentityPatchContext;

class IdentityRollbackCallback
implements IdentityPatchContext.FinalizeCallback {
    private final Patch patch;
    private final Collection<String> patches;
    private final boolean resetConfiguration;
    private final DirectoryStructure directoryStructure;

    public IdentityRollbackCallback(String patchId, Collection<String> patches, boolean resetConfiguration, DirectoryStructure directoryStructure) {
        this.patches = patches;
        this.directoryStructure = directoryStructure;
        this.resetConfiguration = resetConfiguration;
        IdentityImpl identity = new IdentityImpl("", "");
        identity.setPatchType(Patch.PatchType.ONE_OFF);
        this.patch = new PatchImpl(patchId, "no description", identity, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public Patch getPatch() {
        return this.patch;
    }

    @Override
    public void finishPatch(Patch processedPatch, RollbackPatch patch, IdentityPatchContext context) throws Exception {
        context.restoreConfiguration(patch.getPatchId(), this.resetConfiguration);
    }

    @Override
    public void completed(IdentityPatchContext context) {
        InstalledImage installedImage = this.directoryStructure.getInstalledImage();
        File history = installedImage.getPatchHistoryDir(this.patch.getPatchId());
        if (!IoUtils.recursiveDelete(history)) {
            context.failedToCleanupDir(history);
        }
        IdentityRollbackCallback.cleanupEntry(context.getLayers());
        IdentityRollbackCallback.cleanupEntry(context.getAddOns());
        IdentityRollbackCallback.cleanupEntry(Collections.singleton(context.getIdentityEntry()));
    }

    @Override
    public void operationCancelled(IdentityPatchContext context) {
    }

    static void cleanupEntry(Collection<IdentityPatchContext.PatchEntry> entries) {
        for (IdentityPatchContext.PatchEntry entry : entries) {
            entry.cleanupRollbackPatchHistory();
        }
    }
}

