/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.runner.ContentItemFilter;
import org.jboss.as.patching.runner.ContentTaskDefinitions;
import org.jboss.as.patching.runner.IdentityPatchContext;
import org.jboss.as.patching.runner.Location;
import org.jboss.as.patching.runner.PatchingTaskContext;

class PatchingTasks {
    static final EnumSet<ModificationType> ALL_MODIFICATIONS = EnumSet.allOf(ModificationType.class);
    static final EnumSet<ModificationType> ALL_BUT_MODIFY = EnumSet.of(ModificationType.ADD, ModificationType.REMOVE);

    PatchingTasks() {
    }

    static void rollback(String patchId, Collection<ContentModification> originalPatch, Collection<ContentModification> rollbackPatch, ContentTaskDefinitions modifications, ContentItemFilter filter, PatchingTaskContext.Mode mode) {
        HashMap<Location, ContentModification> originalModifications = new HashMap<Location, ContentModification>(originalPatch.size());
        for (ContentModification modification : originalPatch) {
            originalModifications.put(new Location(modification.getItem()), modification);
        }
        for (ContentModification modification : rollbackPatch) {
            byte[] originalTarget;
            byte[] originalContent;
            ContentItem item = modification.getItem();
            if (!filter.accepts(item)) continue;
            Location location = new Location(item);
            ContentModification original = (ContentModification)originalModifications.remove(location);
            ContentEntry contentEntry = new ContentEntry(patchId, modification);
            ContentTaskDefinition definition = modifications.get(location);
            if (definition == null) {
                definition = new ContentTaskDefinition(location, contentEntry, true);
                modifications.put(location, definition);
            } else {
                ContentEntry previous;
                byte[] hash;
                boolean strict = true;
                if (strict && !Arrays.equals(hash = (previous = definition.getTarget()).getItem().getContentHash(), contentEntry.getTargetHash())) {
                    throw new IllegalStateException();
                }
                definition.setTarget(contentEntry);
            }
            if (original == null || mode == PatchingTaskContext.Mode.ROLLBACK) continue;
            byte[] currentContent = modification.getTargetHash();
            if (!Arrays.equals(currentContent, originalContent = original.getItem().getContentHash())) {
                definition.addConflict(contentEntry);
                continue;
            }
            byte[] backupItem = item.getContentHash();
            if (Arrays.equals(backupItem, originalTarget = original.getTargetHash())) continue;
            definition.addConflict(contentEntry);
        }
    }

    static void addMissingModifications(IdentityPatchContext.PatchEntry target, Collection<ContentModification> modifications, ContentItemFilter filter) throws IOException {
        String cpId = target.getCumulativePatchID();
        for (ContentModification modification : modifications) {
            ContentItem item = modification.getItem();
            if (!filter.accepts(item)) continue;
            Location location = new Location(item);
            ContentTaskDefinition definition = target.get(location);
            if (definition == null) {
                target.put(location, new ContentTaskDefinition(location, new ContentEntry(cpId, modification), false));
                continue;
            }
            if (!definition.isRollback()) continue;
            target.prepareForPortForward(item, cpId);
            definition.setTarget(new ContentEntry(cpId, modification));
        }
    }

    static void apply(String patchId, Collection<ContentModification> modifications, IdentityPatchContext.PatchEntry patchEntry) {
        PatchingTasks.apply(patchId, modifications, patchEntry, ContentItemFilter.ALL);
    }

    static void apply(String patchId, Collection<ContentModification> modifications, IdentityPatchContext.PatchEntry patchEntry, ContentItemFilter filter) {
        for (ContentModification modification : modifications) {
            ContentItem item = modification.getItem();
            if (!filter.accepts(item)) continue;
            Location location = new Location(item);
            ContentEntry contentEntry = new ContentEntry(patchId, modification);
            ContentTaskDefinition definition = patchEntry.get(location);
            if (definition == null) {
                definition = new ContentTaskDefinition(location, contentEntry, false);
                patchEntry.put(location, definition);
                continue;
            }
            definition.setTarget(contentEntry);
        }
    }

    static class ContentEntry {
        final String patchId;
        final ContentModification modification;

        ContentEntry(String patchId, ContentModification modification) {
            this.patchId = patchId;
            this.modification = modification;
        }

        public String getPatchId() {
            return this.patchId;
        }

        public ContentModification getModification() {
            return this.modification;
        }

        public ContentItem getItem() {
            return this.modification.getItem();
        }

        public byte[] getTargetHash() {
            return this.modification.getTargetHash();
        }
    }

    static class ContentTaskDefinition {
        private final Location location;
        private final ContentEntry latest;
        private ContentEntry target;
        private boolean rollback;
        private final List<ContentEntry> conflicts = new ArrayList<ContentEntry>();

        ContentTaskDefinition(Location location, ContentEntry latest, boolean rollback) {
            this.location = location;
            this.latest = latest;
            this.target = latest;
            this.rollback = rollback;
        }

        public boolean isRollback() {
            return this.rollback;
        }

        public Location getLocation() {
            return this.location;
        }

        public ContentEntry getLatest() {
            return this.latest;
        }

        public ContentEntry getTarget() {
            return this.target;
        }

        public boolean hasConflicts() {
            return !this.conflicts.isEmpty();
        }

        public List<ContentEntry> getConflicts() {
            return this.conflicts;
        }

        void setTarget(ContentEntry entry) {
            this.target = entry;
            this.rollback = false;
        }

        void addConflict(ContentEntry entry) {
            this.conflicts.add(entry);
        }
    }
}

