/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSubscribeOn<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Scheduler scheduler;
    final boolean nonScheduledRequests;

    public FlowableSubscribeOn(Flowable<T> source, Scheduler scheduler, boolean nonScheduledRequests) {
        super(source);
        this.scheduler = scheduler;
        this.nonScheduledRequests = nonScheduledRequests;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Scheduler.Worker w = this.scheduler.createWorker();
        SubscribeOnSubscriber<? super T> sos = new SubscribeOnSubscriber<T>(s, w, this.source, this.nonScheduledRequests);
        s.onSubscribe(sos);
        w.schedule(sos);
    }

    static final class SubscribeOnSubscriber<T>
    extends AtomicReference<Thread>
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 8094547886072529208L;
        final Subscriber<? super T> actual;
        final Scheduler.Worker worker;
        final AtomicReference<Subscription> s;
        final AtomicLong requested;
        final boolean nonScheduledRequests;
        Publisher<T> source;

        SubscribeOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker, Publisher<T> source, boolean requestOn) {
            this.actual = actual;
            this.worker = worker;
            this.source = source;
            this.s = new AtomicReference();
            this.requested = new AtomicLong();
            this.nonScheduledRequests = !requestOn;
        }

        @Override
        public void run() {
            this.lazySet(Thread.currentThread());
            Publisher<T> src = this.source;
            this.source = null;
            src.subscribe((Subscriber)this);
        }

        @Override
        public void onSubscribe(Subscription s) {
            long r;
            if (SubscriptionHelper.setOnce(this.s, s) && (r = this.requested.getAndSet(0L)) != 0L) {
                this.requestUpstream(r, s);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
            this.worker.dispose();
        }

        public void onComplete() {
            this.actual.onComplete();
            this.worker.dispose();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                Subscription s = this.s.get();
                if (s != null) {
                    this.requestUpstream(n, s);
                } else {
                    long r;
                    BackpressureHelper.add(this.requested, n);
                    s = this.s.get();
                    if (s != null && (r = this.requested.getAndSet(0L)) != 0L) {
                        this.requestUpstream(r, s);
                    }
                }
            }
        }

        void requestUpstream(long n, Subscription s) {
            if (this.nonScheduledRequests || Thread.currentThread() == this.get()) {
                s.request(n);
            } else {
                this.worker.schedule(new Request(s, n));
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.s);
            this.worker.dispose();
        }

        static final class Request
        implements Runnable {
            private final Subscription s;
            private final long n;

            Request(Subscription s, long n) {
                this.s = s;
                this.n = n;
            }

            @Override
            public void run() {
                this.s.request(this.n);
            }
        }
    }
}

