/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.io.IOException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.NoSuchAttributeException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.ldap.CredentialPersister;
import org.wildfly.security.auth.realm.ldap.EvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.realm.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.UserPasswordPasswordUtil;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.util.LdapUtil;

class UserPasswordCredentialLoader
implements CredentialPersister {
    static final String DEFAULT_USER_PASSWORD_ATTRIBUTE_NAME = "userPassword";
    private final String userPasswordAttributeName;

    UserPasswordCredentialLoader(String userPasswordAttributeName) {
        Assert.checkNotNullParam("userPasswordAttributeName", userPasswordAttributeName);
        this.userPasswordAttributeName = userPasswordAttributeName;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        if (credentialType == PasswordCredential.class) {
            if (credentialAlgorithm == null) {
                return SupportLevel.SUPPORTED;
            }
            if (UserPasswordPasswordUtil.isAlgorithmSupported(credentialAlgorithm)) {
                return SupportLevel.POSSIBLY_SUPPORTED;
            }
        }
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public IdentityCredentialPersister forIdentity(DirContext dirContext, String distinguishedName, Attributes attributes) {
        return new ForIdentityLoader(dirContext, distinguishedName, attributes);
    }

    @Override
    public void addRequiredIdentityAttributes(Collection<String> attributes) {
        attributes.add(this.userPasswordAttributeName);
    }

    EvidenceVerifier toEvidenceVerifier() {
        return new EvidenceVerifier(){

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String evidenceAlgorithm) throws RealmUnavailableException {
                if (!PasswordCredential.canVerifyEvidence(evidenceType, evidenceAlgorithm)) {
                    return SupportLevel.UNSUPPORTED;
                }
                return UserPasswordCredentialLoader.this.getCredentialAcquireSupport(PasswordCredential.class, evidenceAlgorithm, null);
            }

            @Override
            public IdentityEvidenceVerifier forIdentity(DirContext dirContext, String distinguishedName, String url, Attributes attributes) throws RealmUnavailableException {
                return new ForIdentityLoader(dirContext, distinguishedName, attributes);
            }

            @Override
            public void addRequiredIdentityAttributes(Collection<String> attributes) {
                attributes.add(UserPasswordCredentialLoader.this.userPasswordAttributeName);
            }
        };
    }

    private class ForIdentityLoader
    implements IdentityCredentialPersister,
    IdentityEvidenceVerifier {
        private final DirContext context;
        private final String distinguishedName;
        private final Attributes attributes;

        public ForIdentityLoader(DirContext context, String distinguishedName, Attributes attributes) {
            this.context = context;
            this.distinguishedName = distinguishedName;
            this.attributes = attributes;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec, Supplier<Provider[]> providers) {
            Credential credential = this.getCredential(credentialType, credentialAlgorithm, parameterSpec, providers);
            if (credential != null) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String evidenceAlgorithm, Supplier<Provider[]> providers) throws RealmUnavailableException {
            if (!PasswordCredential.canVerifyEvidence(evidenceType, evidenceAlgorithm)) {
                return SupportLevel.UNSUPPORTED;
            }
            return this.getCredentialAcquireSupport(PasswordCredential.class, null, null, providers);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec, Supplier<Provider[]> providers) {
            block5: {
                if (credentialType != PasswordCredential.class) {
                    return null;
                }
                try {
                    Attribute attribute = LdapUtil.getBinaryAttribute(this.attributes, UserPasswordCredentialLoader.this.userPasswordAttributeName);
                    if (attribute != null) {
                        int size = attribute.size();
                        for (int i = 0; i < size; ++i) {
                            byte[] value = (byte[])attribute.get(i);
                            Password password = UserPasswordPasswordUtil.parseUserPassword(value);
                            if (!credentialType.isAssignableFrom(PasswordCredential.class) || credentialAlgorithm != null && !credentialAlgorithm.equals(password.getAlgorithm())) continue;
                            return (C)((Credential)credentialType.cast(new PasswordCredential(password)));
                        }
                    }
                }
                catch (InvalidKeySpecException | NamingException e) {
                    if (!ElytronMessages.log.isTraceEnabled()) break block5;
                    ElytronMessages.log.trace("Getting user-password credential " + credentialType.getName() + " failed. dn=" + this.distinguishedName, e);
                }
            }
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence, Supplier<Provider[]> providers) throws RealmUnavailableException {
            PasswordCredential credential = this.getCredential(PasswordCredential.class, null, null, providers);
            if (credential == null) {
                return false;
            }
            return credential.verify(providers, evidence);
        }

        @Override
        public boolean getCredentialPersistSupport(Class<? extends Credential> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec) {
            return credentialType == PasswordCredential.class && (credentialAlgorithm == null || UserPasswordPasswordUtil.isAlgorithmSupported(credentialAlgorithm));
        }

        @Override
        public void persistCredential(Credential credential) throws RealmUnavailableException {
            try {
                byte[] composedPassword = UserPasswordPasswordUtil.composeUserPassword(credential.castAndApply(PasswordCredential.class, PasswordCredential::getPassword));
                Assert.assertNotNull(composedPassword);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(UserPasswordCredentialLoader.this.userPasswordAttributeName, composedPassword);
                this.context.modifyAttributes(this.distinguishedName, 2, (Attributes)attributes);
            }
            catch (IOException | NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialPersistingFailed(credential.toString(), this.distinguishedName, e);
            }
        }

        @Override
        public void clearCredentials() throws RealmUnavailableException {
            try {
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(new BasicAttribute(UserPasswordCredentialLoader.this.userPasswordAttributeName));
                this.context.modifyAttributes(this.distinguishedName, 3, (Attributes)attributes);
            }
            catch (NoSuchAttributeException attributes) {
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialClearingFailed(this.distinguishedName, e);
            }
        }
    }
}

