/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron._private;

import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.security.NoSuchProviderException;
import java.security.Policy;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.x500.cert.acme.AcmeException;

public class ElytronSubsystemMessages_$logger
extends DelegatingBasicLogger
implements ElytronSubsystemMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronSubsystemMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String duplicateRealmInjection = "WFLYELY00002: Can not inject the same realm '%s' in a single security domain.";
    private static final String operationAddressMissingKey = "WFLYELY00003: The operation did not contain an address with a value for '%s'.";
    private static final String unableToStartService = "WFLYELY00004: Unable to start the service.";
    private static final String unableToAccessKeyStore = "WFLYELY00005: Unable to access KeyStore to complete the requested operation.";
    private static final String requiredServiceNotUp = "WFLYELY00007: The required service '%s' is not UP, it is currently '%s'.";
    private static final String invalidOperationName = "WFLYELY00008: Invalid operation name '%s', expected one of '%s'";
    private static final String unableToCompleteOperation = "WFLYELY00009: Unable to complete operation. '%s'";
    private static final String cantSaveWithoutFile = "WFLYELY00010: Unable to save KeyStore - KeyStore file '%s' does not exist.";
    private static final String noSuitableProvider = "WFLYELY00012: No suitable provider found for type '%s'";
    private static final String defaultRealmNotReferenced = "WFLYELY00013: The default-realm '%s' is not in the list of realms [%s] referenced by this domain.";
    private static final String unableToLoadPropertiesFiles = "WFLYELY00014: Unable to load the properties files required to start the properties file backed realm: Users file: '%s' Groups file: '%s'";
    private static final String componentNotConfigurable = "WFLYELY00015: The custom component implementation '%s' doe not implement method initialize(Map<String, String>), however configuration has been supplied.";
    private static final String invalidRegularExpression = "WFLYELY00016: The supplied regular expression '%s' is invalid.";
    private static final String propertyFilesDoesNotExist = "WFLYELY00017: Property file referenced in properties-realm does not exist: %s";
    private static final String unableToCreateManagerFactory = "WFLYELY00018: Unable to create %s for algorithm '%s'.";
    private static final String noTypeFound = "WFLYELY00019: No '%s' found in injected value.";
    private static final String unableToReLoadPropertiesFiles = "WFLYELY00020: Unable to reload the properties files required to by the properties file backed realm.";
    private static final String exceptionWhileCreatingPermission = "WFLYELY00021: Exception while creating the permission object for the permission mapping. Please check [class-name], [target-name] (name of permission) and [action] of [%s].";
    private static final String keyStoreFileNotExists = "WFLYELY00022: KeyStore file '%s' does not exist and required.";
    private static final String keyStoreFileNotExistsButIgnored = "WFLYELY00023: KeyStore file '%s' does not exist. Used blank.";
    private static final String certificateNotValid = "WFLYELY00024: Certificate [%s] in KeyStore is not valid";
    private static final String propertyFileIsInvalid = "WFLYELY00025: Referenced property file is invalid: %s";
    private static final String unableToObtainOidForX500Attribute = "WFLYELY00027: Unable to obtain OID for X.500 attribute '%s'";
    private static final String x500AttributeMustBeDefined = "WFLYELY00028: The X.500 attribute must be defined by name or by OID";
    private static final String invalidURL = "WFLYELY00029: Failed to parse URL '%s'";
    private static final String realmDoesNotSupportCache = "WFLYELY00030: Realm '%s' does not support cache";
    private static final String unableToAccessCRL = "WFLYELY00031: Unable to access CRL file.";
    private static final String unableToReloadCRL = "WFLYELY00032: Unable to reload CRL file.";
    private static final String unableToAccessEntryFromKeyStore = "WFLYELY00033: Unable to access entry [%s] from key store [%s].";
    private static final String jdbcRealmOnlySingleKeyMapperAllowed = "WFLYELY00034: A principal query can only have a single key mapper";
    private static final String unableToLoadModule = "WFLYELY00035: Unable to load module '%s'.";
    private static final String realmRefererencedTwice = "WFLYELY00036: Security realm '%s' has been referenced twice in the same security domain.";
    private static final String invalidTypeInjected = "WFLYELY00037: Injected value is not of '%s' type.";
    private static final String invalidPermissionClass = "WFLYELY00038: Could not load permission class \"%s\"";
    private static final String unableToReloadCRLNotReloadable = "WFLYELY00039: Unable to reload CRL file - TrustManager is not reloadable";
    private static final String invalidPermissionModule = "WFLYELY00040: Unable to load the permission module \"%s\" for the permission mapping";
    private static final String credentialStoreEntryTypeNotSupported = "WFLYELY00909: Credential store '%s' does not support given credential store entry type '%s'";
    private static final String keyStorePasswordCannotBeResolved = "WFLYELY00910: Password cannot be resolved for key-store '%s'";
    private static final String credentialStoreProtectionParameterCannotBeResolved = "WFLYELY00911: Credential store '%s' protection parameter cannot be resolved";
    private static final String credentialAlreadyExists = "WFLYELY00913: Credential alias '%s' of credential type '%s' already exists in the store";
    private static final String providerLoaderCannotSupplyProvider = "WFLYELY00914: Provider loader '%s' cannot supply Credential Store provider of type '%s'";
    private static final String credentialCannotBeResolved = "WFLYELY00916: Credential cannot be resolved";
    private static final String dirContextPasswordCannotBeResolved = "WFLYELY00917: Password cannot be resolved for dir-context";
    private static final String credentialDoesNotExist = "WFLYELY00920: Credential alias '%s' of credential type '%s' does not exist in the store";
    private static final String filebasedKeystoreLocationMissing = "WFLYELY00921: Location parameter is not specified for filebased keystore type '%s'";
    private static final String reloadDependantServices = "Reload dependent services which might already have cached the secret value";
    private static final String updateDependantServices = "Update dependent resources as alias \"%s\" does not exist anymore";
    private static final String identityAlreadyExists = "WFLYELY01000: Identity with name [%s] already exists.";
    private static final String couldNotCreateIdentity = "WFLYELY01001: Could not create identity with name [%s].";
    private static final String identityNotFound = "WFLYELY01002: Identity with name [%s] not found.";
    private static final String couldNotDeleteIdentity = "WFLYELY01003: Could not delete identity with name [%s].";
    private static final String identityNotAuthorized = "WFLYELY01004: Identity with name [%s] not authorized.";
    private static final String couldNotReadIdentity2 = "WFLYELY01005: Could not read identity [%s] from security domain [%s].";
    private static final String couldNotReadIdentity1 = "WFLYELY01007: Could not read identity with name [%s].";
    private static final String couldNotObtainAuthorizationIdentity = "WFLYELY01008: Failed to obtain the authorization identity.";
    private static final String couldNotAddAttribute = "WFLYELY01009: Failed to add attribute.";
    private static final String couldNotRemoveAttribute = "WFLYELY01010: Failed to remove attribute.";
    private static final String couldNotCreatePassword = "WFLYELY01011: Could not create password.";
    private static final String unexpectedPasswordType = "WFLYELY01012: Unexpected password type [%s].";
    private static final String patternRequiresCaptureGroup = "WFLYELY01013: Pattern [%s] requires a capture group";
    private static final String invalidDefinition = "WFLYELY01014: Invalid [%s] definition. Only one of '%s' or '%s' can be set in one Object in the list of filters.";
    private static final String unableToPerformOutflow = "WFLYELY01015: Unable to perform automatic outflow for '%s'";
    private static final String serverNotKnown = "WFLYELY01016: Server '%s' not known";
    private static final String invalidCipherSuiteFilter = "WFLYELY01017: Invalid value for cipher-suite-filter. %s";
    private static final String invalidSize = "WFLYELY01018: Invalid size %s";
    private static final String suffixContainsMillis = "WFLYELY01019: The suffix (%s) can not contain seconds or milliseconds.";
    private static final String invalidSuffix = "WFLYELY01020: The suffix (%s) is invalid. A suffix must be a valid date format.";
    private static final String failedToSetPolicy = "WFLYELY01022: Failed to set policy [%s]";
    private static final String cannotFindPolicyProvider = "WFLYELY01023: Could not find policy provider with name [%s]";
    private static final String failedToRegisterPolicyHandlers = "WFLYELY01024: Failed to register policy context handlers";
    private static final String failedToCreatePolicy = "WFLYELY01025: Failed to create policy [%s]";
    private static final String discardingUnusedPolicy = "WFLYELY01026: Element '%s' with attribute '%s' set to '%s' is unused. Since unused policy configurations can no longer be stored in the configuration model this item is being discarded.";
    private static final String keyPasswordCannotBeResolved = "WFLYELY01027: Key password cannot be resolved for key-store '%s'";
    private static final String invalidNotBefore = "WFLYELY01028: Invalid value for not-before. %s";
    private static final String keyStoreAliasDoesNotExist = "WFLYELY01029: Alias '%s' does not exist in KeyStore";
    private static final String keyStoreAliasDoesNotIdentifyPrivateKeyEntry = "WFLYELY01030: Alias '%s' does not identify a PrivateKeyEntry in KeyStore";
    private static final String unableToObtainPrivateKey = "WFLYELY01031: Unable to obtain PrivateKey for alias '%s'";
    private static final String unableToObtainCertificate = "WFLYELY01032: Unable to obtain Certificate for alias '%s'";
    private static final String noCertificatesFoundInCertificateReply = "WFLYELY01033: No certificates found in certificate reply";
    private static final String publicKeyFromCertificateReplyDoesNotMatchKeyStore = "WFLYELY01034: Public key from certificate reply does not match public key from certificate in KeyStore";
    private static final String certificateReplySameAsCertificateFromKeyStore = "WFLYELY01035: Certificate reply is the same as the certificate from PrivateKeyEntry in KeyStore";
    private static final String keyStoreAliasAlreadyExists = "WFLYELY01036: Alias '%s' already exists in KeyStore";
    private static final String topMostCertificateFromCertificateReplyNotTrusted = "WFLYELY01037: Top-most certificate from certificate reply is not trusted. Inspect the certificate carefully and if it is valid, execute import-certificate again with validate set to false.";
    private static final String trustedCertificateAlreadyInKeyStore = "WFLYELY01038: Trusted certificate is already in KeyStore under alias '%s'";
    private static final String trustedCertificateAlreadyInCacertsKeyStore = "WFLYELY01039: Trusted certificate is already in cacerts KeyStore under alias '%s'";
    private static final String unableToDetermineIfCertificateIsTrusted = "WFLYELY01040: Unable to determine if the certificate is trusted. Inspect the certificate carefully and if it is valid, execute import-certificate again with validate set to false.";
    private static final String certificateFileDoesNotExist = "WFLYELY01041: Certificate file does not exist";
    private static final String unableToObtainEntry = "WFLYELY01042: Unable to obtain Entry for alias '%s'";
    private static final String unableToCreateAccountWithCertificateAuthority = "WFLYELY01043: Unable to create an account with the certificate authority: %s";
    private static final String unableToChangeAccountKeyWithCertificateAuthority = "WFLYELY01044: Unable to change the account key associated with the certificate authority: %s";
    private static final String unableToDeactivateAccountWithCertificateAuthority = "WFLYELY01045: Unable to deactivate the account associated with the certificate authority: %s";
    private static final String unableToObtainCertificateAuthorityAccountCertificate = "WFLYELY01046: Unable to obtain certificate authority account Certificate for alias '%s'";
    private static final String unableToObtainCertificateAuthorityAccountPrivateKey = "WFLYELY01047: Unable to obtain certificate authority account PrivateKey for alias '%s'";
    private static final String unableToUpdateCertificateAuthorityAccountKeyStore = "WFLYELY01048: Unable to update certificate authority account key store: %s";
    private static final String unableToRespondToCertificateAuthorityChallenge = "WFLYELY01049: Unable to respond to challenge from certificate authority: %s";
    private static final String invalidCertificateAuthorityChallenge = "WFLYELY01050: Invalid certificate authority challenge";
    private static final String invalidCertificateRevocationReason = "WFLYELY01051: Invalid certificate revocation reason '%s'";
    private static final String unableToInstatiateAcmeClientSpiImplementation = "WFLYELY01052: Unable to instantiate AcmeClientSpi implementation";
    private static final String unableToUpdateAccountWithCertificateAuthority = "WFLYELY01053: Unable to update the account with the certificate authority: %s";
    private static final String unableToGetCertificateAuthorityMetadata = "WFLYELY01054: Unable to get the metadata associated with the certificate authority: %s";
    private static final String invalidKeySize = "WFLYELY01055: Invalid key size: %d";
    private static final String certificateAuthorityAccountAlreadyExists = "WFLYELY01056: A certificate authority account with this account key already exists. To update the contact information associated with this existing account, use %s. To change the key associated with this existing account, use %s.";

    public ElytronSubsystemMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String duplicateRealmInjection$str() {
        return duplicateRealmInjection;
    }

    @Override
    public final OperationFailedException duplicateRealmInjection(String realmName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.duplicateRealmInjection$str(), realmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String operationAddressMissingKey$str() {
        return operationAddressMissingKey;
    }

    @Override
    public final IllegalArgumentException operationAddressMissingKey(String key) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.operationAddressMissingKey$str(), key));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToStartService$str() {
        return unableToStartService;
    }

    @Override
    public final StartException unableToStartService(Exception cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToStartService$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToAccessKeyStore$str() {
        return unableToAccessKeyStore;
    }

    @Override
    public final OperationFailedException unableToAccessKeyStore(Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToAccessKeyStore$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requiredServiceNotUp$str() {
        return requiredServiceNotUp;
    }

    @Override
    public final OperationFailedException requiredServiceNotUp(ServiceName serviceName, ServiceController.State state) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.requiredServiceNotUp$str(), serviceName, state));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidOperationName$str() {
        return invalidOperationName;
    }

    @Override
    public final OperationFailedException invalidOperationName(String actualName, String ... expectedNames) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidOperationName$str(), actualName, Arrays.toString(expectedNames)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCompleteOperation$str() {
        return unableToCompleteOperation;
    }

    @Override
    public final RuntimeException unableToCompleteOperation(Throwable cause, String causeMessage) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToCompleteOperation$str(), causeMessage), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cantSaveWithoutFile$str() {
        return cantSaveWithoutFile;
    }

    @Override
    public final OperationFailedException cantSaveWithoutFile(String file) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cantSaveWithoutFile$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuitableProvider$str() {
        return noSuitableProvider;
    }

    @Override
    public final StartException noSuitableProvider(String type) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.noSuitableProvider$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String defaultRealmNotReferenced$str() {
        return defaultRealmNotReferenced;
    }

    @Override
    public final OperationFailedException defaultRealmNotReferenced(String defaultRealm, String realms) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.defaultRealmNotReferenced$str(), defaultRealm, realms));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadPropertiesFiles$str() {
        return unableToLoadPropertiesFiles;
    }

    @Override
    public final StartException unableToLoadPropertiesFiles(Exception cause, String usersFile, String groupsFile) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToLoadPropertiesFiles$str(), usersFile, groupsFile), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String componentNotConfigurable$str() {
        return componentNotConfigurable;
    }

    @Override
    public final StartException componentNotConfigurable(String className, Exception cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.componentNotConfigurable$str(), className), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRegularExpression$str() {
        return invalidRegularExpression;
    }

    @Override
    public final OperationFailedException invalidRegularExpression(String pattern, Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidRegularExpression$str(), pattern), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertyFilesDoesNotExist$str() {
        return propertyFilesDoesNotExist;
    }

    @Override
    public final StartException propertyFilesDoesNotExist(String file) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.propertyFilesDoesNotExist$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCreateManagerFactory$str() {
        return unableToCreateManagerFactory;
    }

    @Override
    public final StartException unableToCreateManagerFactory(String type, String algorithm) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToCreateManagerFactory$str(), type, algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noTypeFound$str() {
        return noTypeFound;
    }

    @Override
    public final StartException noTypeFound(String type) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.noTypeFound$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReLoadPropertiesFiles$str() {
        return unableToReLoadPropertiesFiles;
    }

    @Override
    public final OperationFailedException unableToReLoadPropertiesFiles(Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToReLoadPropertiesFiles$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String exceptionWhileCreatingPermission$str() {
        return exceptionWhileCreatingPermission;
    }

    @Override
    public final StartException exceptionWhileCreatingPermission(String permissionClassName, Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.exceptionWhileCreatingPermission$str(), permissionClassName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStoreFileNotExists$str() {
        return keyStoreFileNotExists;
    }

    @Override
    public final StartException keyStoreFileNotExists(String file) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.keyStoreFileNotExists$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void keyStoreFileNotExistsButIgnored(String file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.keyStoreFileNotExistsButIgnored$str(), (Object)file);
    }

    protected String keyStoreFileNotExistsButIgnored$str() {
        return keyStoreFileNotExistsButIgnored;
    }

    @Override
    public final void certificateNotValid(String alias, Exception cause) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)cause, this.certificateNotValid$str(), (Object)alias);
    }

    protected String certificateNotValid$str() {
        return certificateNotValid;
    }

    protected String propertyFileIsInvalid$str() {
        return propertyFileIsInvalid;
    }

    @Override
    public final StartException propertyFileIsInvalid(String message, Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.propertyFileIsInvalid$str(), message), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToObtainOidForX500Attribute$str() {
        return unableToObtainOidForX500Attribute;
    }

    @Override
    public final OperationFailedException unableToObtainOidForX500Attribute(String attribute) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToObtainOidForX500Attribute$str(), attribute));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String x500AttributeMustBeDefined$str() {
        return x500AttributeMustBeDefined;
    }

    @Override
    public final OperationFailedException x500AttributeMustBeDefined() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.x500AttributeMustBeDefined$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidURL$str() {
        return invalidURL;
    }

    @Override
    public final OperationFailedException invalidURL(String url, Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidURL$str(), url), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String realmDoesNotSupportCache$str() {
        return realmDoesNotSupportCache;
    }

    @Override
    public final StartException realmDoesNotSupportCache(String realmName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.realmDoesNotSupportCache$str(), realmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToAccessCRL$str() {
        return unableToAccessCRL;
    }

    @Override
    public final StartException unableToAccessCRL(Exception cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToAccessCRL$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReloadCRL$str() {
        return unableToReloadCRL;
    }

    @Override
    public final RuntimeException unableToReloadCRL(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToReloadCRL$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToAccessEntryFromKeyStore$str() {
        return unableToAccessEntryFromKeyStore;
    }

    @Override
    public final RuntimeException unableToAccessEntryFromKeyStore(String alias, String keyStore) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToAccessEntryFromKeyStore$str(), alias, keyStore));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jdbcRealmOnlySingleKeyMapperAllowed$str() {
        return jdbcRealmOnlySingleKeyMapperAllowed;
    }

    @Override
    public final OperationFailedException jdbcRealmOnlySingleKeyMapperAllowed() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.jdbcRealmOnlySingleKeyMapperAllowed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadModule$str() {
        return unableToLoadModule;
    }

    @Override
    public final OperationFailedException unableToLoadModule(String module, Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToLoadModule$str(), module), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String realmRefererencedTwice$str() {
        return realmRefererencedTwice;
    }

    @Override
    public final OperationFailedException realmRefererencedTwice(String realmName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.realmRefererencedTwice$str(), realmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTypeInjected$str() {
        return invalidTypeInjected;
    }

    @Override
    public final StartException invalidTypeInjected(String type) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidTypeInjected$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPermissionClass$str() {
        return invalidPermissionClass;
    }

    @Override
    public final StartException invalidPermissionClass(String className) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidPermissionClass$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReloadCRLNotReloadable$str() {
        return unableToReloadCRLNotReloadable;
    }

    @Override
    public final OperationFailedException unableToReloadCRLNotReloadable() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToReloadCRLNotReloadable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPermissionModule$str() {
        return invalidPermissionModule;
    }

    @Override
    public final StartException invalidPermissionModule(String module, Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidPermissionModule$str(), module), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialStoreEntryTypeNotSupported$str() {
        return credentialStoreEntryTypeNotSupported;
    }

    @Override
    public final OperationFailedException credentialStoreEntryTypeNotSupported(String credentialStoreName, String entryType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.credentialStoreEntryTypeNotSupported$str(), credentialStoreName, entryType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStorePasswordCannotBeResolved$str() {
        return keyStorePasswordCannotBeResolved;
    }

    @Override
    public final IOException keyStorePasswordCannotBeResolved(String path) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.keyStorePasswordCannotBeResolved$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialStoreProtectionParameterCannotBeResolved$str() {
        return credentialStoreProtectionParameterCannotBeResolved;
    }

    @Override
    public final IOException credentialStoreProtectionParameterCannotBeResolved(String name) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.credentialStoreProtectionParameterCannotBeResolved$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialAlreadyExists$str() {
        return credentialAlreadyExists;
    }

    @Override
    public final OperationFailedException credentialAlreadyExists(String alias, String credentialType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.credentialAlreadyExists$str(), alias, credentialType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String providerLoaderCannotSupplyProvider$str() {
        return providerLoaderCannotSupplyProvider;
    }

    @Override
    public final NoSuchProviderException providerLoaderCannotSupplyProvider(String providerLoader, String type) {
        NoSuchProviderException result = new NoSuchProviderException(String.format(this.getLoggingLocale(), this.providerLoaderCannotSupplyProvider$str(), providerLoader, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialCannotBeResolved$str() {
        return credentialCannotBeResolved;
    }

    @Override
    public final IllegalStateException credentialCannotBeResolved() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.credentialCannotBeResolved$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String dirContextPasswordCannotBeResolved$str() {
        return dirContextPasswordCannotBeResolved;
    }

    @Override
    public final StartException dirContextPasswordCannotBeResolved(Exception cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.dirContextPasswordCannotBeResolved$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialDoesNotExist$str() {
        return credentialDoesNotExist;
    }

    @Override
    public final OperationFailedException credentialDoesNotExist(String alias, String credentialType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.credentialDoesNotExist$str(), alias, credentialType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String filebasedKeystoreLocationMissing$str() {
        return filebasedKeystoreLocationMissing;
    }

    @Override
    public final OperationFailedException filebasedKeystoreLocationMissing(String type) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.filebasedKeystoreLocationMissing$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String reloadDependantServices$str() {
        return reloadDependantServices;
    }

    @Override
    public final String reloadDependantServices() {
        return String.format(this.getLoggingLocale(), this.reloadDependantServices$str(), new Object[0]);
    }

    protected String updateDependantServices$str() {
        return updateDependantServices;
    }

    @Override
    public final String updateDependantServices(String alias) {
        return String.format(this.getLoggingLocale(), this.updateDependantServices$str(), alias);
    }

    protected String identityAlreadyExists$str() {
        return identityAlreadyExists;
    }

    @Override
    public final OperationFailedException identityAlreadyExists(String principalName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.identityAlreadyExists$str(), principalName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateIdentity$str() {
        return couldNotCreateIdentity;
    }

    @Override
    public final RuntimeException couldNotCreateIdentity(String principalName, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotCreateIdentity$str(), principalName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String identityNotFound$str() {
        return identityNotFound;
    }

    @Override
    public final String identityNotFound(String principalName) {
        return String.format(this.getLoggingLocale(), this.identityNotFound$str(), principalName);
    }

    protected String couldNotDeleteIdentity$str() {
        return couldNotDeleteIdentity;
    }

    @Override
    public final RuntimeException couldNotDeleteIdentity(String principalName, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotDeleteIdentity$str(), principalName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String identityNotAuthorized$str() {
        return identityNotAuthorized;
    }

    @Override
    public final String identityNotAuthorized(String principalName) {
        return String.format(this.getLoggingLocale(), this.identityNotAuthorized$str(), principalName);
    }

    protected String couldNotReadIdentity2$str() {
        return couldNotReadIdentity2;
    }

    @Override
    public final RuntimeException couldNotReadIdentity(String principalName, ServiceName domainServiceName, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotReadIdentity2$str(), principalName, domainServiceName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotReadIdentity1$str() {
        return couldNotReadIdentity1;
    }

    @Override
    public final RuntimeException couldNotReadIdentity(String principalName, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotReadIdentity1$str(), principalName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotObtainAuthorizationIdentity$str() {
        return couldNotObtainAuthorizationIdentity;
    }

    @Override
    public final RuntimeException couldNotObtainAuthorizationIdentity(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotObtainAuthorizationIdentity$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotAddAttribute$str() {
        return couldNotAddAttribute;
    }

    @Override
    public final RuntimeException couldNotAddAttribute(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotAddAttribute$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotRemoveAttribute$str() {
        return couldNotRemoveAttribute;
    }

    @Override
    public final RuntimeException couldNotRemoveAttribute(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotRemoveAttribute$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreatePassword$str() {
        return couldNotCreatePassword;
    }

    @Override
    public final RuntimeException couldNotCreatePassword(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotCreatePassword$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedPasswordType$str() {
        return unexpectedPasswordType;
    }

    @Override
    public final OperationFailedException unexpectedPasswordType(String passwordType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unexpectedPasswordType$str(), passwordType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patternRequiresCaptureGroup$str() {
        return patternRequiresCaptureGroup;
    }

    @Override
    public final OperationFailedException patternRequiresCaptureGroup(String pattern) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.patternRequiresCaptureGroup$str(), pattern));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidDefinition$str() {
        return invalidDefinition;
    }

    @Override
    public final OperationFailedException invalidDefinition(String property, String filterNameOne, String filterNameTwo) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidDefinition$str(), property, filterNameOne, filterNameTwo));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToPerformOutflow$str() {
        return unableToPerformOutflow;
    }

    @Override
    public final IllegalStateException unableToPerformOutflow(String identityName, Exception cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToPerformOutflow$str(), identityName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotKnown$str() {
        return serverNotKnown;
    }

    @Override
    public final OperationFailedException serverNotKnown(String server, UnknownHostException e) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.serverNotKnown$str(), server), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCipherSuiteFilter$str() {
        return invalidCipherSuiteFilter;
    }

    @Override
    public final OperationFailedException invalidCipherSuiteFilter(Throwable cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidCipherSuiteFilter$str(), causeMessage), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSize$str() {
        return invalidSize;
    }

    @Override
    public final OperationFailedException invalidSize(String size) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidSize$str(), size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String suffixContainsMillis$str() {
        return suffixContainsMillis;
    }

    @Override
    public final OperationFailedException suffixContainsMillis(String suffix) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.suffixContainsMillis$str(), suffix));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSuffix$str() {
        return invalidSuffix;
    }

    @Override
    public final OperationFailedException invalidSuffix(String suffix) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidSuffix$str(), suffix));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToSetPolicy$str() {
        return failedToSetPolicy;
    }

    @Override
    public final RuntimeException failedToSetPolicy(Policy policy, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToSetPolicy$str(), policy), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindPolicyProvider$str() {
        return cannotFindPolicyProvider;
    }

    @Override
    public final XMLStreamException cannotFindPolicyProvider(String policyProvider, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.cannotFindPolicyProvider$str(), policyProvider), location);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToRegisterPolicyHandlers$str() {
        return failedToRegisterPolicyHandlers;
    }

    @Override
    public final RuntimeException failedToRegisterPolicyHandlers(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToRegisterPolicyHandlers$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToCreatePolicy$str() {
        return failedToCreatePolicy;
    }

    @Override
    public final RuntimeException failedToCreatePolicy(String className, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToCreatePolicy$str(), className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void discardingUnusedPolicy(String element, String attr, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.discardingUnusedPolicy$str(), (Object)element, (Object)attr, (Object)name);
    }

    protected String discardingUnusedPolicy$str() {
        return discardingUnusedPolicy;
    }

    protected String keyPasswordCannotBeResolved$str() {
        return keyPasswordCannotBeResolved;
    }

    @Override
    public final IOException keyPasswordCannotBeResolved(String path) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.keyPasswordCannotBeResolved$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNotBefore$str() {
        return invalidNotBefore;
    }

    @Override
    public final OperationFailedException invalidNotBefore(Throwable cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidNotBefore$str(), causeMessage), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStoreAliasDoesNotExist$str() {
        return keyStoreAliasDoesNotExist;
    }

    @Override
    public final OperationFailedException keyStoreAliasDoesNotExist(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.keyStoreAliasDoesNotExist$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStoreAliasDoesNotIdentifyPrivateKeyEntry$str() {
        return keyStoreAliasDoesNotIdentifyPrivateKeyEntry;
    }

    @Override
    public final OperationFailedException keyStoreAliasDoesNotIdentifyPrivateKeyEntry(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.keyStoreAliasDoesNotIdentifyPrivateKeyEntry$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToObtainPrivateKey$str() {
        return unableToObtainPrivateKey;
    }

    @Override
    public final OperationFailedException unableToObtainPrivateKey(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToObtainPrivateKey$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToObtainCertificate$str() {
        return unableToObtainCertificate;
    }

    @Override
    public final OperationFailedException unableToObtainCertificate(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToObtainCertificate$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noCertificatesFoundInCertificateReply$str() {
        return noCertificatesFoundInCertificateReply;
    }

    @Override
    public final OperationFailedException noCertificatesFoundInCertificateReply() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noCertificatesFoundInCertificateReply$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String publicKeyFromCertificateReplyDoesNotMatchKeyStore$str() {
        return publicKeyFromCertificateReplyDoesNotMatchKeyStore;
    }

    @Override
    public final OperationFailedException publicKeyFromCertificateReplyDoesNotMatchKeyStore() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.publicKeyFromCertificateReplyDoesNotMatchKeyStore$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certificateReplySameAsCertificateFromKeyStore$str() {
        return certificateReplySameAsCertificateFromKeyStore;
    }

    @Override
    public final OperationFailedException certificateReplySameAsCertificateFromKeyStore() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.certificateReplySameAsCertificateFromKeyStore$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStoreAliasAlreadyExists$str() {
        return keyStoreAliasAlreadyExists;
    }

    @Override
    public final OperationFailedException keyStoreAliasAlreadyExists(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.keyStoreAliasAlreadyExists$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String topMostCertificateFromCertificateReplyNotTrusted$str() {
        return topMostCertificateFromCertificateReplyNotTrusted;
    }

    @Override
    public final OperationFailedException topMostCertificateFromCertificateReplyNotTrusted() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.topMostCertificateFromCertificateReplyNotTrusted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String trustedCertificateAlreadyInKeyStore$str() {
        return trustedCertificateAlreadyInKeyStore;
    }

    @Override
    public final OperationFailedException trustedCertificateAlreadyInKeyStore(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.trustedCertificateAlreadyInKeyStore$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String trustedCertificateAlreadyInCacertsKeyStore$str() {
        return trustedCertificateAlreadyInCacertsKeyStore;
    }

    @Override
    public final OperationFailedException trustedCertificateAlreadyInCacertsKeyStore(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.trustedCertificateAlreadyInCacertsKeyStore$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineIfCertificateIsTrusted$str() {
        return unableToDetermineIfCertificateIsTrusted;
    }

    @Override
    public final OperationFailedException unableToDetermineIfCertificateIsTrusted() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToDetermineIfCertificateIsTrusted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certificateFileDoesNotExist$str() {
        return certificateFileDoesNotExist;
    }

    @Override
    public final OperationFailedException certificateFileDoesNotExist(Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.certificateFileDoesNotExist$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToObtainEntry$str() {
        return unableToObtainEntry;
    }

    @Override
    public final OperationFailedException unableToObtainEntry(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToObtainEntry$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCreateAccountWithCertificateAuthority$str() {
        return unableToCreateAccountWithCertificateAuthority;
    }

    @Override
    public final OperationFailedException unableToCreateAccountWithCertificateAuthority(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToCreateAccountWithCertificateAuthority$str(), causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToChangeAccountKeyWithCertificateAuthority$str() {
        return unableToChangeAccountKeyWithCertificateAuthority;
    }

    @Override
    public final OperationFailedException unableToChangeAccountKeyWithCertificateAuthority(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToChangeAccountKeyWithCertificateAuthority$str(), causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDeactivateAccountWithCertificateAuthority$str() {
        return unableToDeactivateAccountWithCertificateAuthority;
    }

    @Override
    public final OperationFailedException unableToDeactivateAccountWithCertificateAuthority(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToDeactivateAccountWithCertificateAuthority$str(), causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToObtainCertificateAuthorityAccountCertificate$str() {
        return unableToObtainCertificateAuthorityAccountCertificate;
    }

    @Override
    public final StartException unableToObtainCertificateAuthorityAccountCertificate(String alias) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToObtainCertificateAuthorityAccountCertificate$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToObtainCertificateAuthorityAccountPrivateKey$str() {
        return unableToObtainCertificateAuthorityAccountPrivateKey;
    }

    @Override
    public final StartException unableToObtainCertificateAuthorityAccountPrivateKey(String alias) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToObtainCertificateAuthorityAccountPrivateKey$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToUpdateCertificateAuthorityAccountKeyStore$str() {
        return unableToUpdateCertificateAuthorityAccountKeyStore;
    }

    @Override
    public final OperationFailedException unableToUpdateCertificateAuthorityAccountKeyStore(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToUpdateCertificateAuthorityAccountKeyStore$str(), causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToRespondToCertificateAuthorityChallenge$str() {
        return unableToRespondToCertificateAuthorityChallenge;
    }

    @Override
    public final AcmeException unableToRespondToCertificateAuthorityChallenge(Exception cause, String causeMessage) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToRespondToCertificateAuthorityChallenge$str(), causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCertificateAuthorityChallenge$str() {
        return invalidCertificateAuthorityChallenge;
    }

    @Override
    public final AcmeException invalidCertificateAuthorityChallenge() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.invalidCertificateAuthorityChallenge$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCertificateRevocationReason$str() {
        return invalidCertificateRevocationReason;
    }

    @Override
    public final OperationFailedException invalidCertificateRevocationReason(String reason) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidCertificateRevocationReason$str(), reason));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstatiateAcmeClientSpiImplementation$str() {
        return unableToInstatiateAcmeClientSpiImplementation;
    }

    @Override
    public final IllegalStateException unableToInstatiateAcmeClientSpiImplementation() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToInstatiateAcmeClientSpiImplementation$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToUpdateAccountWithCertificateAuthority$str() {
        return unableToUpdateAccountWithCertificateAuthority;
    }

    @Override
    public final OperationFailedException unableToUpdateAccountWithCertificateAuthority(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToUpdateAccountWithCertificateAuthority$str(), causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGetCertificateAuthorityMetadata$str() {
        return unableToGetCertificateAuthorityMetadata;
    }

    @Override
    public final OperationFailedException unableToGetCertificateAuthorityMetadata(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToGetCertificateAuthorityMetadata$str(), causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySize$str() {
        return invalidKeySize;
    }

    @Override
    public final OperationFailedException invalidKeySize(int keySize) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidKeySize$str(), keySize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certificateAuthorityAccountAlreadyExists$str() {
        return certificateAuthorityAccountAlreadyExists;
    }

    @Override
    public final OperationFailedException certificateAuthorityAccountAlreadyExists(String updateAccount, String changeAccountKey) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.certificateAuthorityAccountAlreadyExists$str(), updateAccount, changeAccountKey));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

