/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron._private;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.x500.cert.acme.AcmeAccount;
import org.wildfly.security.x500.cert.acme.AcmeChallenge;
import org.wildfly.security.x500.cert.acme.AcmeClientSpi;
import org.wildfly.security.x500.cert.acme.AcmeException;

public final class WildFlyAcmeClient
extends AcmeClientSpi {
    private static final String ACME_CHALLENGE_PREFIX = "/.well-known/acme-challenge/";
    private static final String TOKEN_REGEX = "[A-Za-z0-9_-]+";

    public AcmeChallenge proveIdentifierControl(AcmeAccount account, List<AcmeChallenge> challenges) throws AcmeException {
        String token;
        Assert.checkNotNullParam((String)"account", (Object)account);
        Assert.checkNotNullParam((String)"challenges", challenges);
        AcmeChallenge selectedChallenge = null;
        for (AcmeChallenge challenge : challenges) {
            if (challenge.getType() != AcmeChallenge.Type.HTTP_01) continue;
            selectedChallenge = challenge;
            break;
        }
        if (!(token = selectedChallenge.getToken()).matches(TOKEN_REGEX)) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.invalidCertificateAuthorityChallenge();
        }
        String responseFilePath = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", (String)".") + ACME_CHALLENGE_PREFIX + token;
        try (FileOutputStream fos = new FileOutputStream(responseFilePath);){
            fos.write(selectedChallenge.getKeyAuthorization(account).getBytes(StandardCharsets.US_ASCII));
        }
        catch (IOException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToRespondToCertificateAuthorityChallenge(e, e.getLocalizedMessage());
        }
        return selectedChallenge;
    }

    public void cleanupAfterChallenge(AcmeAccount account, AcmeChallenge challenge) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        Assert.checkNotNullParam((String)"challenge", (Object)challenge);
        String token = challenge.getToken();
        if (!token.matches(TOKEN_REGEX)) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.invalidCertificateAuthorityChallenge();
        }
        String responseFilePath = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", (String)".") + ACME_CHALLENGE_PREFIX + token;
        File responseFile = new File(responseFilePath);
        if (responseFile.exists()) {
            responseFile.delete();
        }
    }
}

