/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static Method[] getDeclaredMethods(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getDeclaredMethods();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return c.getDeclaredMethods();
            }
        });
    }

    static Field[] getDeclaredFields(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getDeclaredFields();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return c.getDeclaredFields();
            }
        });
    }

    static void setAccessible(final AccessibleObject ao) {
        if (System.getSecurityManager() == null) {
            ao.setAccessible(true);
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ao.setAccessible(true);
                return null;
            }
        });
    }

    static Constructor<?> getConstructor(final Class<?> c, final Class<?> ... params) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return c.getConstructor(params);
        }
        Constructor result = (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<?>>(){

            @Override
            public Constructor<?> run() {
                try {
                    return c.getConstructor(params);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchMethodException();
    }

    static Method getMethod(final Class<?> c, final String name, final Class<?> ... params) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return c.getMethod(name, params);
        }
        Method result = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return c.getMethod(name, params);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchMethodException();
    }
}

