/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.util.ArrayList;
import org.jboss.common.beans.property.GenericArrayPropertyEditor;

public class StringArrayEditor
extends GenericArrayPropertyEditor<String[]> {
    public StringArrayEditor() {
        super(String[].class);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
            return;
        }
        this.setValue(this.tokenize(text));
    }

    @Override
    protected String[] tokenize(String text) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer tmp = new StringBuffer();
        block4: for (int n = 0; n < text.length(); ++n) {
            char c = text.charAt(n);
            switch (c) {
                case '\\': {
                    tmp.append("\\");
                    if (n >= text.length() || text.charAt(n + 1) != ',') continue block4;
                    tmp.setCharAt(tmp.length() - 1, ',');
                    ++n;
                    continue block4;
                }
                case '\n': 
                case '\r': 
                case ',': {
                    if (tmp.length() > 0) {
                        list.add(tmp.toString());
                    }
                    tmp.setLength(0);
                    continue block4;
                }
                default: {
                    tmp.append(c);
                }
            }
        }
        if (tmp.length() > 0) {
            list.add(tmp.toString());
        }
        String[] x = new String[list.size()];
        list.toArray(x);
        return x;
    }

    @Override
    protected String encode(String[] v) {
        if (v == null) {
            return null;
        }
        StringBuffer text = new StringBuffer();
        for (int n = 0; n < v.length; ++n) {
            String s = v[n];
            if (s.contains(",")) {
                s = s.replace(",", "\\,");
            }
            text.append(s);
            text.append(',');
        }
        if (text.length() > 0) {
            text.setLength(text.length() - 1);
        }
        return text.toString();
    }
}

