/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.mtom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.type.mtom.AbstractXOPType;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.message.Attachment;

public class ByteArrayType
extends AbstractXOPType {
    public ByteArrayType(boolean useXmimeBinaryType, String expectedContentTypes) {
        super(useXmimeBinaryType, expectedContentTypes);
        this.setTypeClass((Type)((Object)byte[].class));
    }

    @Override
    protected Object readAttachment(Attachment att, Context context) throws IOException {
        DataHandler handler = att.getDataHandler();
        InputStream is = handler.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayType.copy(is, out);
        is.close();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream input, OutputStream output) throws IOException {
        try {
            byte[] buffer = new byte[8096];
            int n = input.read(buffer);
            while (-1 != n) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        finally {
            output.close();
            input.close();
        }
    }

    @Override
    protected Attachment createAttachment(Object object, String id) {
        byte[] data = (byte[])object;
        ByteDataSource source = new ByteDataSource(data);
        source.setContentType(this.getContentType(object, null));
        AttachmentImpl att = new AttachmentImpl(id, new DataHandler((DataSource)source));
        att.setXOP(true);
        return att;
    }

    @Override
    protected String getContentType(Object object, Context context) {
        return "application/octet-stream";
    }

    @Override
    protected Object wrapBytes(byte[] bareBytes, String contentType) {
        return bareBytes;
    }

    @Override
    protected byte[] getBytes(Object object) {
        return (byte[])object;
    }
}

