/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.web.infinispan.session.AbstractImmutableSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaData;

public class SimpleSessionMetaData
extends AbstractImmutableSessionMetaData
implements InvalidatableSessionMetaData {
    private final SessionCreationMetaData creationMetaData;
    private final SessionAccessMetaData accessMetaData;

    public SimpleSessionMetaData(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData) {
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
    }

    @Override
    public boolean isNew() {
        return this.accessMetaData.getLastAccessedDuration().isZero();
    }

    @Override
    public boolean isValid() {
        return this.creationMetaData.isValid();
    }

    @Override
    public boolean invalidate() {
        return this.creationMetaData.invalidate();
    }

    public Instant getCreationTime() {
        return this.creationMetaData.getCreationTime();
    }

    public Instant getLastAccessedTime() {
        return this.getCreationTime().plus(this.accessMetaData.getLastAccessedDuration());
    }

    public Duration getMaxInactiveInterval() {
        return this.creationMetaData.getMaxInactiveInterval();
    }

    public void setLastAccessedTime(Instant instant) {
        this.accessMetaData.setLastAccessedDuration(Duration.between(this.creationMetaData.getCreationTime(), instant));
    }

    public void setMaxInactiveInterval(Duration duration) {
        this.creationMetaData.setMaxInactiveInterval(duration.isNegative() ? Duration.ZERO : duration);
    }
}

