/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core.handlers;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.Location;
import org.projectodd.vdx.core.ErrorHandler;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Position;
import org.projectodd.vdx.core.Util;
import org.projectodd.vdx.core.ValidationContext;
import org.projectodd.vdx.core.ValidationError;
import org.projectodd.vdx.core.schema.SchemaElement;

public class RequiredElementMissingHandler
implements ErrorHandler {
    private final I18N.Key primaryMessageKey;
    private final I18N.Key optionsMessageKey;

    public RequiredElementMissingHandler() {
        this(I18N.Key.ELEMENT_REQUIRED_MISSING, I18N.Key.ELEMENT_REQUIRED_MISSING_LIST);
    }

    protected RequiredElementMissingHandler(I18N.Key primaryMessageKey, I18N.Key optionsMessageKey) {
        this.primaryMessageKey = primaryMessageKey;
        this.optionsMessageKey = optionsMessageKey;
    }

    @Override
    public ErrorHandler.HandledResult handle(ValidationContext ctx, ValidationError error) {
        String el = error.element().getLocalPart();
        Set<String> alts = error.alternatives();
        Location loc = error.location();
        Position pos = ctx.searchBackward(loc.getLineNumber() - 1, loc.getColumnNumber(), Pattern.compile(String.format("<%s[ >/]", el)));
        ErrorHandler.HandledResult result = ErrorHandler.HandledResult.from(error).addPrimaryMessage(this.primaryMessageKey, el);
        if (pos != null) {
            result.line(pos.line).column(pos.col);
        }
        if (!alts.isEmpty()) {
            List<SchemaElement> path = ctx.mapDocLocationToSchemaPath(error.element(), error.position());
            if (path.isEmpty()) {
                result.possiblyMalformed(true);
            }
            Set<String> otherElements = ctx.elementsForElement(path).stream().map(SchemaElement::name).collect(Collectors.toSet());
            result.addPrimaryMessage(this.optionsMessageKey, Util.asSortedList(alts).stream().map(String::toLowerCase).map(Util.possiblyUnderscoredName(otherElements)).collect(Collectors.toList()));
        }
        return result;
    }
}

