/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.jgroups;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;

public class JGroupsReceiver
extends ReceiverAdapter {
    private static final Logger logger = Logger.getLogger(JGroupsReceiver.class);
    private final BlockingQueue<byte[]> dequeue = new LinkedBlockingDeque<byte[]>();

    @Override
    public void receive(Message msg) {
        if (logger.isTraceEnabled()) {
            logger.trace("sending message " + msg);
        }
        this.dequeue.add(msg.getBuffer());
    }

    public byte[] receiveBroadcast() throws Exception {
        byte[] bytes = this.dequeue.take();
        if (logger.isTraceEnabled()) {
            this.logBytes("receiveBroadcast()", bytes);
        }
        return bytes;
    }

    private void logBytes(String methodName, byte[] bytes) {
        if (bytes != null) {
            logger.trace(methodName + "::" + bytes.length + " bytes");
        } else {
            logger.trace(methodName + ":: no bytes");
        }
    }

    public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
        byte[] bytes = this.dequeue.poll(time, unit);
        if (logger.isTraceEnabled()) {
            this.logBytes("receiveBroadcast(long time, TimeUnit unit)", bytes);
        }
        return bytes;
    }
}

