/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

public class Buffer {
    private final byte[] buf;
    private final int offset;
    private final int length;

    public Buffer(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
    }

    public Buffer(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Buffer copy() {
        int new_length;
        byte[] new_buf = this.buf != null ? new byte[this.length] : null;
        int n = new_length = new_buf != null ? new_buf.length : 0;
        if (new_buf != null) {
            System.arraycopy(this.buf, this.offset, new_buf, 0, this.length);
        }
        return new Buffer(new_buf, 0, new_length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.length).append(" bytes");
        if (this.offset > 0) {
            sb.append(" (offset=").append(this.offset).append(")");
        }
        return sb.toString();
    }
}

