/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.common.Assert;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;

public final class MutableDiscoveryProvider
implements DiscoveryProvider {
    private final AtomicReference<DiscoveryProvider> delegateRef;

    public MutableDiscoveryProvider(DiscoveryProvider initialProvider) {
        Assert.checkNotNullParam("initialProvider", initialProvider);
        this.delegateRef = new AtomicReference<DiscoveryProvider>(initialProvider);
    }

    public MutableDiscoveryProvider() {
        this(EMPTY);
    }

    public void setDiscoveryProvider(DiscoveryProvider delegateProvider) {
        Assert.checkNotNullParam("delegateProvider", delegateProvider);
        this.delegateRef.set(delegateProvider);
    }

    @Override
    public DiscoveryRequest discover(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult result) {
        return this.delegateRef.get().discover(serviceType, filterSpec, result);
    }
}

