/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal.model.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jdbc.internal.model.PartitionJdbcType;
import org.picketlink.idm.jdbc.internal.model.db.AbstractStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.AttributeStorageUtil;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.QueryParameter;

public class UserStorageUtil
extends AbstractStorageUtil {
    public int countUsers(DataSource dataSource, String id) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block5: {
            int n;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                connection = dataSource.getConnection();
                String sql = "select count(*) from User where id =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, id);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                n = resultSet.getInt(1);
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return n;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return 0;
    }

    public void deleteAgent(DataSource dataSource, Agent agent) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            String sql = "delete from User where id=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, agent.getId());
            int result = preparedStatement.executeUpdate();
            if (result == 0) {
                throw new RuntimeException("Delete Agent failed");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public void deleteUser(DataSource dataSource, User user) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            String sql = "delete from User where id=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, user.getId());
            int result = preparedStatement.executeUpdate();
            if (result == 0) {
                throw new RuntimeException("Delete User failed");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public User loadUser(DataSource dataSource, Map<QueryParameter, Object[]> params) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Set<QueryParameter> queryParameters = params.keySet();
        for (QueryParameter queryParameter : queryParameters) {
            if (!(queryParameter instanceof AttributeParameter)) continue;
            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
            Object[] paramValues = this.getValuesFromParamMap(params, attributeParameter);
            String attributeName = attributeParameter.getName();
            if ("loginName".equals(attributeName)) {
                String loginNameValue = (String)paramValues[0];
                return this.loadUserByLoginName(dataSource, loginNameValue);
            }
            throw new RuntimeException();
        }
        throw new RuntimeException();
    }

    public User loadUser(DataSource dataSource, String id) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            User user;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                Timestamp expirationDate;
                connection = dataSource.getConnection();
                String sql = "select firstName,lastName,email,loginName,partitionID,enabled,createdDate,expirationDate from User where id =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, id);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block9;
                User user2 = new User();
                user2.setFirstName(resultSet.getString(1));
                user2.setLastName(resultSet.getString(2));
                user2.setEmail(resultSet.getString(3));
                user2.setLoginName(resultSet.getString(4));
                user2.setPartition(this.loadPartition(dataSource, resultSet.getString(5)));
                user2.setEnabled("y".equalsIgnoreCase(resultSet.getString(6)));
                Timestamp creationDate = resultSet.getTimestamp(7);
                if (creationDate != null) {
                    user2.setCreatedDate(new Date(creationDate.getTime()));
                }
                if ((expirationDate = resultSet.getTimestamp(8)) != null) {
                    user2.setExpirationDate(new Date(expirationDate.getTime()));
                }
                user2.setId(id);
                AttributeStorageUtil attributeStorageUtil = new AttributeStorageUtil();
                List<Attribute> attributeList = attributeStorageUtil.getAttributes(dataSource, id);
                if (!attributeList.isEmpty()) {
                    for (Attribute attribute : attributeList) {
                        user2.setAttribute(attribute);
                    }
                }
                user = user2;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return user;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public User loadUserByLoginName(DataSource dataSource, String loginName) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            User user;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                AttributeStorageUtil attributeStorageUtil;
                List<Attribute> attributeList;
                Timestamp expirationDate;
                connection = dataSource.getConnection();
                String sql = "select id, firstName,lastName,email,partitionID,enabled,createdDate,expirationDate from User where loginName =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, loginName);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block9;
                User user2 = new User();
                user2.setId(resultSet.getString(1));
                user2.setFirstName(resultSet.getString(2));
                user2.setLastName(resultSet.getString(3));
                user2.setEmail(resultSet.getString(4));
                user2.setLoginName(loginName);
                user2.setPartition(this.loadPartition(dataSource, resultSet.getString(5)));
                user2.setEnabled("y".equalsIgnoreCase(resultSet.getString(6)));
                Timestamp creationDate = resultSet.getTimestamp(7);
                if (creationDate != null) {
                    user2.setCreatedDate(new Date(creationDate.getTime()));
                }
                if ((expirationDate = resultSet.getTimestamp(8)) != null) {
                    user2.setExpirationDate(new Date(expirationDate.getTime()));
                }
                if (!(attributeList = (attributeStorageUtil = new AttributeStorageUtil()).getAttributes(dataSource, user2.getId())).isEmpty()) {
                    for (Attribute attribute : attributeList) {
                        user2.setAttribute(attribute);
                    }
                }
                user = user2;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return user;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public void storeAgent(DataSource dataSource, Agent agent) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        String storeSql = "insert into user set loginName=?,id=?,createdDate=?,partitionID=?,enabled=?,expirationDate=?";
        if (agent.getExpirationDate() == null) {
            storeSql = "insert into user set loginName=?,id=?,createdDate=?,partitionID=?,enabled=?";
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            int result;
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement(storeSql);
            preparedStatement.setString(1, agent.getLoginName());
            preparedStatement.setString(2, agent.getId());
            preparedStatement.setTimestamp(3, new Timestamp(agent.getCreatedDate().getTime()));
            preparedStatement.setString(4, agent.getPartition().getId());
            String enabledStr = "n";
            if (agent.isEnabled()) {
                enabledStr = "y";
            }
            preparedStatement.setString(5, enabledStr);
            if (agent.getExpirationDate() != null) {
                preparedStatement.setTimestamp(6, new Timestamp(agent.getExpirationDate().getTime()));
            }
            if ((result = preparedStatement.executeUpdate()) == 0) {
                throw new RuntimeException("Insert agent failed");
            }
            PartitionJdbcType pj = new PartitionJdbcType("dummy");
            pj.setDataSource(dataSource);
            pj.persist((AttributedType)agent.getPartition());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public void storeUser(DataSource dataSource, User user) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        String storeSql = "insert into user set firstName=?,lastName=?,email=?,loginName=?,id=?,createdDate=?,partitionID=?,enabled=?,expirationDate=?";
        if (user.getExpirationDate() == null) {
            storeSql = "insert into user set firstName=?,lastName=?,email=?,loginName=?,id=?,createdDate=?,partitionID=?,enabled=?";
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            int result;
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement(storeSql);
            preparedStatement.setString(1, user.getFirstName());
            preparedStatement.setString(2, user.getLastName());
            preparedStatement.setString(3, user.getEmail());
            preparedStatement.setString(4, user.getLoginName());
            preparedStatement.setString(5, user.getId());
            preparedStatement.setTimestamp(6, new Timestamp(user.getCreatedDate().getTime()));
            preparedStatement.setString(7, user.getPartition().getId());
            String enabledStr = "n";
            if (user.isEnabled()) {
                enabledStr = "y";
            }
            preparedStatement.setString(8, enabledStr);
            if (user.getExpirationDate() != null) {
                preparedStatement.setTimestamp(9, new Timestamp(user.getExpirationDate().getTime()));
            }
            if ((result = preparedStatement.executeUpdate()) == 0) {
                throw new RuntimeException("Insert into user failed");
            }
            PartitionJdbcType pj = new PartitionJdbcType("dummy");
            pj.setDataSource(dataSource);
            pj.persist((AttributedType)user.getPartition());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public void updateAgent(DataSource dataSource, Agent agent) {
        String updateSql = "update User set loginName=?,enabled=?,createdDate=?,expirationDate=? where id =?";
        if (agent.getExpirationDate() == null) {
            updateSql = "update User set loginName=?,enabled=?,createdDate=? where id =?";
        }
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement(updateSql);
            preparedStatement.setString(1, agent.getLoginName());
            if (agent.isEnabled()) {
                preparedStatement.setString(2, "y");
            } else {
                preparedStatement.setString(2, "n");
            }
            preparedStatement.setTimestamp(3, new Timestamp(agent.getCreatedDate().getTime()));
            if (agent.getExpirationDate() != null) {
                preparedStatement.setTimestamp(4, new Timestamp(agent.getExpirationDate().getTime()));
                preparedStatement.setString(5, agent.getId());
            } else {
                preparedStatement.setString(4, agent.getId());
            }
            int numberOfRows = preparedStatement.executeUpdate();
            if (numberOfRows == 0) {
                System.out.println("Update Agent failed");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
        }
    }

    public void updateUser(DataSource dataSource, User user) {
        String updateSql = "update User set firstName=?,lastName=?,email=?,loginName=?,enabled=?,createdDate=?,expirationDate=? where id =?";
        if (user.getExpirationDate() == null) {
            updateSql = "update User set firstName=?,lastName=?,email=?,loginName=?,enabled=?,createdDate=? where id =?";
        }
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement(updateSql);
            preparedStatement.setString(1, user.getFirstName());
            preparedStatement.setString(2, user.getLastName());
            preparedStatement.setString(3, user.getEmail());
            preparedStatement.setString(4, user.getLoginName());
            if (user.isEnabled()) {
                preparedStatement.setString(5, "y");
            } else {
                preparedStatement.setString(5, "n");
            }
            preparedStatement.setTimestamp(6, new Timestamp(user.getCreatedDate().getTime()));
            if (user.getExpirationDate() != null) {
                preparedStatement.setTimestamp(7, new Timestamp(user.getExpirationDate().getTime()));
                preparedStatement.setString(8, user.getId());
            } else {
                preparedStatement.setString(7, user.getId());
            }
            int numberOfRows = preparedStatement.executeUpdate();
            if (numberOfRows == 0) {
                System.out.println("Update user failed");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
        }
    }
}

