/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManagerImpl;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.metadata.LayerType;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.version.ProductConfig;

public abstract class InstallationManager {
    public abstract InstalledIdentity getDefaultIdentity();

    public abstract List<InstalledIdentity> getInstalledIdentities() throws PatchingException;

    public abstract InstalledIdentity getInstalledIdentity(String var1, String var2) throws PatchingException;

    public abstract InstalledImage getInstalledImage();

    public abstract boolean requiresRestart();

    public abstract boolean restartRequired();

    public abstract void clearRestartRequired();

    public static InstallationManager load(File jbossHome, List<File> moduleRoots, List<File> bundlesRoots, ProductConfig productConfig) throws IOException {
        InstalledImage installedImage = InstalledIdentity.installedImage(jbossHome);
        return new InstallationManagerImpl(installedImage, moduleRoots, bundlesRoots, productConfig);
    }

    public static interface ModificationCompletionCallback {
        public void completed();

        public void canceled();
    }

    public static interface MutablePatchingTarget
    extends PatchableTarget.TargetInfo {
        public void rollback(String var1);

        public boolean isRolledback(String var1);

        public void apply(String var1, Patch.PatchType var2);

        public boolean isApplied(String var1);

        public PatchableTarget.TargetInfo getModifiedState();
    }

    public static interface InstallationModification
    extends MutablePatchingTarget {
        public String getName();

        public String getVersion();

        public void setResultingVersion(String var1);

        public void addInstalledPatch(String var1) throws PatchingException;

        public void removeInstalledPatch(String var1) throws PatchingException;

        public InstalledIdentity getUnmodifiedInstallationState();

        public MutablePatchingTarget resolve(String var1, LayerType var2);

        public void complete();

        public void cancel();
    }
}

