/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JSESecurityMetaData {
    private final String transportGuarantee;
    private final Map<String, JSEResourceCollection> webResources;

    protected JSESecurityMetaData(String transportGuarantee, HashMap<String, JSEResourceCollection> webResources) {
        this.transportGuarantee = transportGuarantee;
        this.webResources = webResources;
    }

    public Collection<JSEResourceCollection> getWebResources() {
        return this.webResources.values();
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public static class JSEResourceCollection {
        private final String name;
        private final Set<String> urlPatterns;

        public JSEResourceCollection(String name, Collection<String> urlPatterns) {
            this.name = name;
            this.urlPatterns = urlPatterns != null && !urlPatterns.isEmpty() ? Collections.unmodifiableSet(new HashSet<String>(urlPatterns)) : Collections.emptySet();
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getUrlPatterns() {
            return this.urlPatterns;
        }
    }

    public static class Builder {
        private String transportGuarantee;
        private HashMap<String, JSEResourceCollection> webResources = new HashMap();

        public JSESecurityMetaData build() {
            return new JSESecurityMetaData(this.transportGuarantee, this.webResources);
        }

        public void addWebResource(String name, Collection<String> urlPatterns) {
            JSEResourceCollection wrc = new JSEResourceCollection(name, urlPatterns);
            this.webResources.put(name, wrc);
        }

        public void setTransportGuarantee(String transportGuarantee) {
            this.transportGuarantee = transportGuarantee;
        }
    }
}

