/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.session.RouteLocatorServiceConfiguratorProvider;
import org.wildfly.clustering.web.undertow.session.DistributableSessionIdentifierCodecServiceConfigurator;
import org.wildfly.clustering.web.undertow.session.RouteServiceConfigurator;
import org.wildfly.extension.undertow.session.SimpleSessionIdentifierCodecServiceConfigurator;

public class DistributableSessionIdentifierCodecServiceConfiguratorProvider
implements org.wildfly.extension.undertow.session.DistributableSessionIdentifierCodecServiceConfiguratorProvider {
    private static final RouteLocatorServiceConfiguratorProvider PROVIDER = DistributableSessionIdentifierCodecServiceConfiguratorProvider.loadProvider();

    private static RouteLocatorServiceConfiguratorProvider loadProvider() {
        Iterator<RouteLocatorServiceConfiguratorProvider> iterator = ServiceLoader.load(RouteLocatorServiceConfiguratorProvider.class, RouteLocatorServiceConfiguratorProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            RouteLocatorServiceConfiguratorProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    public CapabilityServiceConfigurator getDeploymentServiceConfigurator(ServiceName name, String serverName, String deploymentName) {
        return PROVIDER != null ? new DistributableSessionIdentifierCodecServiceConfigurator(name, serverName, deploymentName, PROVIDER) : new SimpleSessionIdentifierCodecServiceConfigurator(name, serverName);
    }

    public Collection<CapabilityServiceConfigurator> getServerServiceConfigurators(String serverName) {
        LinkedList<CapabilityServiceConfigurator> configurators = new LinkedList<CapabilityServiceConfigurator>();
        RouteServiceConfigurator routeConfigurator = new RouteServiceConfigurator(serverName);
        configurators.add(routeConfigurator);
        ServiceSupplierDependency routeDependency = new ServiceSupplierDependency(routeConfigurator.getServiceName());
        if (PROVIDER != null) {
            configurators.addAll(PROVIDER.getRouteLocatorConfigurationServiceConfigurators(serverName, (SupplierDependency)routeDependency));
        }
        return configurators;
    }
}

