/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.distribution.ch.impl.TopologyAwareConsistentHashFactory;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ConsistentHashStrategy;
import org.jboss.as.clustering.infinispan.subsystem.SegmentedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class SegmentedCacheServiceConfigurator
extends SharedStateCacheServiceConfigurator {
    private final SupplierDependency<GlobalConfiguration> global;
    private volatile ConsistentHashStrategy consistentHashStrategy;
    private volatile int segments;

    SegmentedCacheServiceConfigurator(PathAddress address, CacheMode mode) {
        super(address, mode);
        this.global = new ServiceSupplierDependency(CacheContainerResourceDefinition.Capability.CONFIGURATION.getServiceName(address.getParent()));
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return super.register(this.global.register(builder));
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.consistentHashStrategy = (ConsistentHashStrategy)ModelNodes.asEnum((ModelNode)SegmentedCacheResourceDefinition.Attribute.CONSISTENT_HASH_STRATEGY.resolveModelAttribute((ExpressionResolver)context, model), ConsistentHashStrategy.class);
        this.segments = SegmentedCacheResourceDefinition.Attribute.SEGMENTS.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        return super.configure(context, model);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        super.accept(builder);
        HashConfigurationBuilder hash = builder.clustering().hash().numSegments(this.segments);
        if (this.consistentHashStrategy == ConsistentHashStrategy.INTRA_CACHE) {
            hash.consistentHashFactory((ConsistentHashFactory)(((GlobalConfiguration)this.global.get()).transport().hasTopologyInfo() ? new TopologyAwareConsistentHashFactory() : new DefaultConsistentHashFactory()));
        }
    }
}

