/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.function.Consumer;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteServiceNameProvider;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.RemoteSiteConfiguration;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class RemoteSiteConfigurationServiceConfigurator
extends RemoteSiteServiceNameProvider
implements ResourceServiceConfigurator,
RemoteSiteConfiguration {
    private final String siteName;
    private volatile SupplierDependency<String> cluster;
    private volatile SupplierDependency<ChannelFactory> factory;

    public RemoteSiteConfigurationServiceConfigurator(PathAddress address) {
        super(address);
        this.siteName = address.getLastElement().getValue();
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer configuration = new CompositeDependency(new Dependency[]{this.cluster, this.factory}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)configuration, (Object)this);
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String channel = RemoteSiteResourceDefinition.Attribute.CHANNEL.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.cluster = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL_CLUSTER.getServiceName(context, channel));
        this.factory = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(context, channel));
        return this;
    }

    public String getName() {
        return this.siteName;
    }

    public ChannelFactory getChannelFactory() {
        return (ChannelFactory)this.factory.get();
    }

    public String getClusterName() {
        return (String)this.cluster.get();
    }
}

