/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.jgroups.subsystem.MulticastTransportConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.TransportConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

public class TransportRegistration
implements Registration<ManagementResourceRegistration> {
    private final ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory;

    public TransportRegistration(ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory) {
        this.parentServiceConfiguratorFactory = parentServiceConfiguratorFactory;
    }

    public void register(ManagementResourceRegistration registration) {
        new TransportResourceDefinition(new TransportResourceServiceConfiguratorFactory(), this.parentServiceConfiguratorFactory).register(registration);
    }

    static class TransportResourceServiceConfiguratorFactory
    implements ResourceServiceConfiguratorFactory {
        TransportResourceServiceConfiguratorFactory() {
        }

        public ResourceServiceConfigurator createServiceConfigurator(PathAddress address) {
            return MulticastTransport.contains(address.getLastElement().getValue()) ? new MulticastTransportConfigurationServiceConfigurator(address) : new TransportConfigurationServiceConfigurator(address);
        }
    }

    static enum MulticastTransport {
        UDP;


        static boolean contains(String name) {
            for (MulticastTransport protocol : EnumSet.allOf(MulticastTransport.class)) {
                if (!name.equals(protocol.name())) continue;
                return true;
            }
            return false;
        }
    }
}

