/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.validator;

import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.SecurityActions;

public class FailureHelper {
    private static final String NEW_LINE = SecurityActions.getSystemProperty("line.separator");
    private final Collection<Failure> failures;

    public FailureHelper(Collection<Failure> failures) {
        this.failures = failures;
    }

    public String asText(ResourceBundle rb) {
        StringBuilder sb = new StringBuilder();
        if (this.failures != null) {
            int i = 0;
            Iterator<Failure> iterator = this.failures.iterator();
            while (iterator.hasNext()) {
                Failure failure;
                Failure f = failure = iterator.next();
                sb = sb.append(f.asText(rb));
                if (i < this.failures.size() - 1) {
                    sb = sb.append(NEW_LINE);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public String asXML(ResourceBundle rb) {
        StringBuilder sb = new StringBuilder();
        if (this.failures != null) {
            int i = 0;
            Iterator<Failure> iterator = this.failures.iterator();
            while (iterator.hasNext()) {
                Failure failure;
                Failure f = failure = iterator.next();
                sb = sb.append(f.asXML(rb));
                if (i < this.failures.size() - 1) {
                    sb = sb.append(NEW_LINE);
                }
                ++i;
            }
        }
        return sb.toString();
    }
}

