/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public abstract class AbstractAction
extends ConnectionAbstract {
    public void performCoreManagement(ManagementCallback<ClientMessage> cb) throws Exception {
        try (ActiveMQConnectionFactory factory = this.createCoreConnectionFactory();
             ServerLocator locator = factory.getServerLocator();
             ClientSessionFactory sessionFactory = locator.createSessionFactory();
             ClientSession session = sessionFactory.createSession(this.user, this.password, false, true, true, false, 0x100000);){
            session.start();
            ClientRequestor requestor = new ClientRequestor(session, "activemq.management");
            ClientMessage message = session.createMessage(false);
            cb.setUpInvocation(message);
            ClientMessage reply = requestor.request(message);
            if (ManagementHelper.hasOperationSucceeded((Message)reply)) {
                cb.requestSuccessful(reply);
            } else {
                cb.requestFailed(reply);
            }
        }
    }

    public static interface ManagementCallback<T> {
        public void setUpInvocation(T var1) throws Exception;

        public void requestSuccessful(T var1) throws Exception;

        public void requestFailed(T var1) throws Exception;
    }
}

