/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.user;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.utils.StringUtil;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;

class FileBasedSecStoreConfig {
    private static final String LICENSE_HEADER = "## ---------------------------------------------------------------------------\n## Licensed to the Apache Software Foundation (ASF) under one or more\n## contributor license agreements.  See the NOTICE file distributed with\n## this work for additional information regarding copyright ownership.\n## The ASF licenses this file to You under the Apache License, Version 2.0\n## (the \"License\"); you may not use this file except in compliance with\n## the License.  You may obtain a copy of the License at\n##\n## http://www.apache.org/licenses/LICENSE-2.0\n##\n## Unless required by applicable law or agreed to in writing, software\n## distributed under the License is distributed on an \"AS IS\" BASIS,\n## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n## See the License for the specific language governing permissions and\n## limitations under the License.\n## ---------------------------------------------------------------------------\n";
    private FileBasedConfigurationBuilder<PropertiesConfiguration> userBuilder;
    private FileBasedConfigurationBuilder<PropertiesConfiguration> roleBuilder;
    private PropertiesConfiguration userConfig;
    private PropertiesConfiguration roleConfig;

    FileBasedSecStoreConfig(File userFile, File roleFile) throws Exception {
        Configurations configs = new Configurations();
        this.userBuilder = configs.propertiesBuilder(userFile);
        this.roleBuilder = configs.propertiesBuilder(roleFile);
        this.userConfig = (PropertiesConfiguration)this.userBuilder.getConfiguration();
        this.roleConfig = (PropertiesConfiguration)this.roleBuilder.getConfiguration();
        String roleHeader = this.roleConfig.getLayout().getHeaderComment();
        String userHeader = this.userConfig.getLayout().getHeaderComment();
        if (userHeader == null && this.userConfig.isEmpty()) {
            this.userConfig.clear();
            this.userConfig.setHeader(LICENSE_HEADER);
        }
        if (roleHeader == null && this.roleConfig.isEmpty()) {
            this.roleConfig.clear();
            this.roleConfig.setHeader(LICENSE_HEADER);
        }
    }

    void addNewUser(String username, String hash, String ... roles) throws Exception {
        if (this.userConfig.getString(username) != null) {
            throw new IllegalArgumentException("User already exist: " + username);
        }
        this.userConfig.addProperty(username, (Object)hash);
        this.addRoles(username, roles);
    }

    void save() throws Exception {
        this.userBuilder.save();
        this.roleBuilder.save();
    }

    void removeUser(String username) throws Exception {
        if (this.userConfig.getProperty(username) == null) {
            throw new IllegalArgumentException("user " + username + " doesn't exist.");
        }
        this.userConfig.clearProperty(username);
        this.removeRoles(username);
    }

    List<String> listUser(String username) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("--- \"user\"(roles) ---\n");
        int totalUsers = 0;
        if (username != null) {
            String roles = this.findRoles(username);
            result.add("\"" + username + "\"(" + roles + ")");
            ++totalUsers;
        } else {
            Iterator iter = this.userConfig.getKeys();
            while (iter.hasNext()) {
                String keyUser = (String)iter.next();
                String roles = this.findRoles(keyUser);
                result.add("\"" + keyUser + "\"(" + roles + ")");
                ++totalUsers;
            }
        }
        result.add("\n Total: " + totalUsers);
        return result;
    }

    void updateUser(String username, String password, String[] roles) {
        String oldPassword = (String)this.userConfig.getProperty(username);
        if (oldPassword == null) {
            throw new IllegalArgumentException("user " + username + " doesn't exist.");
        }
        if (password != null) {
            this.userConfig.setProperty(username, (Object)password);
        }
        if (roles != null && roles.length > 0) {
            this.removeRoles(username);
            this.addRoles(username, roles);
        }
    }

    private String findRoles(String uname) {
        Iterator iter = this.roleConfig.getKeys();
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        while (iter.hasNext()) {
            String role = (String)iter.next();
            List names = this.roleConfig.getList(String.class, role);
            for (String value : names) {
                String[] items;
                for (String item : items = value.split(",")) {
                    if (!item.equals(uname)) continue;
                    if (!first) {
                        builder.append(",");
                    }
                    builder.append(role);
                    first = false;
                }
            }
        }
        return builder.toString();
    }

    private void addRoles(String username, String[] roles) {
        for (String role : roles) {
            ArrayList<String> users = this.roleConfig.getList(String.class, role);
            if (users == null) {
                users = new ArrayList<String>();
            }
            users.add(username);
            this.roleConfig.setProperty(role, (Object)StringUtil.joinStringList(users, (String)","));
        }
    }

    private void removeRoles(String username) {
        Iterator iterKeys = this.roleConfig.getKeys();
        ArrayList<Pair> updateMap = new ArrayList<Pair>();
        while (iterKeys.hasNext()) {
            String theRole = (String)iterKeys.next();
            List userList = this.roleConfig.getList(String.class, theRole);
            ArrayList<String> newList = new ArrayList<String>();
            boolean roleChaned = false;
            for (String value : userList) {
                ArrayList<String> update = new ArrayList<String>();
                String[] items = value.split(",");
                boolean found = false;
                for (String item : items) {
                    if (!item.equals(username)) {
                        update.add(item);
                        continue;
                    }
                    found = true;
                    roleChaned = true;
                }
                if (!found || update.size() <= 0) continue;
                newList.add(StringUtil.joinStringList(update, (String)","));
            }
            if (!roleChaned) continue;
            updateMap.add(new Pair((Object)theRole, newList));
        }
        for (Pair entry : updateMap) {
            this.roleConfig.clearProperty((String)entry.getA());
            if (((List)entry.getB()).size() <= 0) continue;
            this.roleConfig.addProperty((String)entry.getA(), entry.getB());
        }
    }
}

