/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.infinispan.notifications.cachelistener.event.Event;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;

public class ClusteringServerLogger_$logger
extends DelegatingBasicLogger
implements ClusteringServerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ClusteringServerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String startSingleton = "WFLYCLSV0001: This node will now operate as the singleton provider of the %s service";
    private static final String stopSingleton = "WFLYCLSV0002: This node will no longer operate as the singleton provider of the %s service";
    private static final String elected = "WFLYCLSV0003: %s elected as the singleton provider of the %s service";
    private static final String noResponseFromMaster = "WFLYCLSV0004: No response received from master node of the %s service, retrying...";
    private static final String serviceStartFailed = "WFLYCLSV0005: Failed to start %s service";
    private static final String quorumNotReached = "WFLYCLSV0006: Failed to reach quorum of %2$d for %1$s service. No singleton master will be elected.";
    private static final String quorumJustReached = "WFLYCLSV0007: Just reached required quorum of %2$d for %1$s service. If this cluster loses another member, no node will be chosen to provide this service.";
    private static final String multiplePrimaryProvidersDetected = "WFLYCLSV0008: Detected multiple primary providers for %s service: %s";
    private static final String notStarted = "WFLYCLSV0009: Singleton service %s is not started.";
    private static final String registryPurgeFailed = "WFLYCLSV0010: Failed to purge %s/%s registry of old registry entries for: %s";
    private static final String registryListenerFailed = "WFLYCLSV0011: Failed to notify %s/%s registry listener of %s(%s) event";
    private static final String serviceProviderRegistrationListenerFailed = "WFLYCLSV0012: Failed to notify %s/%s service provider registration listener of new providers: %s";
    private static final String noPrimaryElected = "WFLYCLSV0013: No node was elected as the singleton provider of the %s service";
    private static final String invalidQuorum = "WFLYCLSV0014: Specified quorum %d must be greater than zero";
    private static final String failedToRestoreLocalRegistryEntry = "WFLYCLSV0015: Failed to restore local %s/%s registry entry following network partititon merge";
    private static final String commandDispatcherAlreadyExists = "WFLYCLSV0016: A command dispatcher already exists for %s";
    private static final String commandDispatcherContextMismatch = "WFLYCLSV0017: A command dispatcher for %s already exists, but with a different command context";

    public ClusteringServerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void startSingleton(String service) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startSingleton$str(), (Object)service);
    }

    protected String startSingleton$str() {
        return startSingleton;
    }

    @Override
    public final void stopSingleton(String service) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stopSingleton$str(), (Object)service);
    }

    protected String stopSingleton$str() {
        return stopSingleton;
    }

    @Override
    public final void elected(String node, String service) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.elected$str(), (Object)node, (Object)service);
    }

    protected String elected$str() {
        return elected;
    }

    protected String noResponseFromMaster$str() {
        return noResponseFromMaster;
    }

    @Override
    public final IllegalStateException noResponseFromMaster(String service) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noResponseFromMaster$str(), service));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void serviceStartFailed(StartException e, String service) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.serviceStartFailed$str(), (Object)service);
    }

    protected String serviceStartFailed$str() {
        return serviceStartFailed;
    }

    @Override
    public final void quorumNotReached(String service, int quorum) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.quorumNotReached$str(), (Object)service, (Object)quorum);
    }

    protected String quorumNotReached$str() {
        return quorumNotReached;
    }

    @Override
    public final void quorumJustReached(String service, int quorum) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.quorumJustReached$str(), (Object)service, (Object)quorum);
    }

    protected String quorumJustReached$str() {
        return quorumJustReached;
    }

    protected String multiplePrimaryProvidersDetected$str() {
        return multiplePrimaryProvidersDetected;
    }

    @Override
    public final IllegalArgumentException multiplePrimaryProvidersDetected(String serviceName, Collection<Node> nodes) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.multiplePrimaryProvidersDetected$str(), serviceName, nodes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notStarted$str() {
        return notStarted;
    }

    @Override
    public final IllegalStateException notStarted(String serviceName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notStarted$str(), serviceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void registryPurgeFailed(Throwable e, String containerName, String cacheName, Collection<?> members) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.registryPurgeFailed$str(), (Object)containerName, (Object)cacheName, members);
    }

    protected String registryPurgeFailed$str() {
        return registryPurgeFailed;
    }

    @Override
    public final void registryListenerFailed(Throwable e, String containerName, String cacheName, Event.Type type, Map<?, ?> entries) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.registryListenerFailed$str(), new Object[]{containerName, cacheName, type, entries});
    }

    protected String registryListenerFailed$str() {
        return registryListenerFailed;
    }

    @Override
    public final void serviceProviderRegistrationListenerFailed(Throwable e, String containerName, String cacheName, Set<Node> providers) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.serviceProviderRegistrationListenerFailed$str(), (Object)containerName, (Object)cacheName, providers);
    }

    protected String serviceProviderRegistrationListenerFailed$str() {
        return serviceProviderRegistrationListenerFailed;
    }

    @Override
    public final void noPrimaryElected(String service) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noPrimaryElected$str(), (Object)service);
    }

    protected String noPrimaryElected$str() {
        return noPrimaryElected;
    }

    protected String invalidQuorum$str() {
        return invalidQuorum;
    }

    @Override
    public final IllegalArgumentException invalidQuorum(int quorum) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidQuorum$str(), quorum));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void failedToRestoreLocalRegistryEntry(Throwable cause, String containerName, String cacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToRestoreLocalRegistryEntry$str(), (Object)containerName, (Object)cacheName);
    }

    protected String failedToRestoreLocalRegistryEntry$str() {
        return failedToRestoreLocalRegistryEntry;
    }

    protected String commandDispatcherAlreadyExists$str() {
        return commandDispatcherAlreadyExists;
    }

    @Override
    public final IllegalArgumentException commandDispatcherAlreadyExists(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.commandDispatcherAlreadyExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String commandDispatcherContextMismatch$str() {
        return commandDispatcherContextMismatch;
    }

    @Override
    public final IllegalArgumentException commandDispatcherContextMismatch(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.commandDispatcherContextMismatch$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

