/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceBuilderFactory;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceConfiguratorFactoryContext;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;

public class CacheSingletonServiceConfiguratorFactoryServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
DistributedSingletonServiceConfiguratorFactoryContext {
    private final String containerName;
    private final String cacheName;
    private volatile ServiceName registryServiceName;
    private volatile ServiceName dispatcherFactoryServiceName;

    public CacheSingletonServiceConfiguratorFactoryServiceConfigurator(ServiceName name, String containerName, String cacheName) {
        super(name);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.registryServiceName = ClusteringCacheRequirement.SERVICE_PROVIDER_REGISTRY.getServiceName(support, this.containerName, this.cacheName);
        this.dispatcherFactoryServiceName = ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, this.containerName);
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = builder.provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)factory, (Object)new DistributedSingletonServiceBuilderFactory(this));
        return builder.setInstance(service);
    }

    @Override
    public ServiceName getServiceProviderRegistryServiceName() {
        return this.registryServiceName;
    }

    @Override
    public ServiceName getCommandDispatcherFactoryServiceName() {
        return this.dispatcherFactoryServiceName;
    }
}

