/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueManager;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;

public class QueueManagerImpl
extends ReferenceCounterUtil
implements QueueManager {
    private final SimpleString queueName;
    private final ActiveMQServer server;

    private void doIt() {
        Queue queue = this.server.locateQueue(this.queueName);
        if (queue == null) {
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("pno queue to delete \"" + this.queueName + ".\"");
            }
            return;
        }
        SimpleString address = queue.getAddress();
        AddressSettings settings = this.server.getAddressSettingsRepository().getMatch(address.toString());
        long consumerCount = queue.getConsumerCount();
        long messageCount = queue.getMessageCount();
        if (queue.isAutoCreated() && settings.isAutoDeleteQueues() && queue.getMessageCount() == 0L && queue.getConsumerCount() == 0) {
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("deleting " + (queue.isAutoCreated() ? "auto-created " : "") + "queue \"" + this.queueName + ".\" consumerCount = " + consumerCount + "; messageCount = " + messageCount + "; isAutoDeleteQueues = " + settings.isAutoDeleteQueues());
            }
            try {
                this.server.destroyQueue(this.queueName, null, true, false);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingAutoCreatedQueue(e, this.queueName);
            }
        } else if (queue.isPurgeOnNoConsumers()) {
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("purging queue \"" + this.queueName + ".\" consumerCount = " + consumerCount + "; messageCount = " + messageCount);
            }
            try {
                queue.deleteMatchingReferences(500, null, AckReason.KILLED);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToPurgeQueue(e, this.queueName);
            }
        }
    }

    public QueueManagerImpl(ActiveMQServer server, SimpleString queueName) {
        this.server = server;
        this.queueName = queueName;
        this.setTask(this::doIt);
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }
}

