/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.internal.arjuna.recovery.Listener;
import com.arjuna.ats.internal.arjuna.recovery.WorkerService;
import java.io.IOException;
import java.net.ServerSocket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class PeriodicRecovery
extends Thread {
    private final Vector<RecoveryModule> _recoveryModules = new Vector();
    private int _backoffPeriod = 0;
    private int _recoveryPeriod = 0;
    private int _periodicRecoveryInitilizationOffset = 0;
    public static final int _defaultBackoffPeriod = 10;
    public static final int _defaultRecoveryPeriod = 120;
    private final Object _stateLock = new Object();
    private Status _currentStatus;
    private Mode _currentMode;
    private boolean _workerScanRequested = false;
    private SimpleDateFormat _theTimestamper = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
    private ServerSocket _socket = null;
    private final Object _socketLock = new Object();
    private Listener _listener = null;
    private WorkerService _workerService = null;

    public PeriodicRecovery(boolean threaded, boolean useListener) {
        super("Periodic Recovery");
        this.initialise();
        this.loadModules();
        if (useListener) {
            try {
                this._workerService = new WorkerService(this);
                this._listener = new Listener(this.getServerSocket(), (Service)this._workerService);
                this._listener.setDaemon(true);
                tsLogger.i18NLogger.info_recovery_PeriodicRecovery_13(this._socket.getInetAddress().getHostAddress(), Integer.toString(this._socket.getLocalPort()));
            }
            catch (Exception ex) {
                tsLogger.i18NLogger.warn_recovery_PeriodicRecovery_9(ex);
            }
        }
        if (threaded) {
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug((Object)"PeriodicRecovery: starting background scanner thread");
            }
            this.start();
        }
        if (useListener && this._listener != null) {
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug((Object)"PeriodicRecovery: starting listener worker thread");
            }
            this._listener.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean async) {
        if (this._listener != null) {
            this._listener.stopListener();
        }
        Object object = this._stateLock;
        synchronized (object) {
            if (this.getMode() != Mode.TERMINATED) {
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: Mode <== TERMINATED");
                }
                this.setMode(Mode.TERMINATED);
                this._stateLock.notifyAll();
            }
            if (!async) {
                while (this.getStatus() == Status.SCANNING) {
                    try {
                        if (tsLogger.logger.isDebugEnabled()) {
                            tsLogger.logger.debug((Object)"PeriodicRecovery: shutdown waiting for scan to end");
                        }
                        this._stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: shutdown scan wait complete");
                }
            }
        }
        if (!async && this.isAlive()) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mode suspendScan(boolean async) {
        Object object = this._stateLock;
        synchronized (object) {
            Mode currentMode = this.getMode();
            if (currentMode == Mode.ENABLED) {
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: Mode <== SUSPENDED");
                }
                this.setMode(Mode.SUSPENDED);
                this._stateLock.notifyAll();
            }
            if (!async) {
                while (this.getStatus() == Status.SCANNING) {
                    try {
                        if (tsLogger.logger.isDebugEnabled()) {
                            tsLogger.logger.debug((Object)"PeriodicRecovery: suspendScan waiting for scan to end");
                        }
                        this._stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!tsLogger.logger.isDebugEnabled()) continue;
                    tsLogger.logger.debug((Object)"PeriodicRecovery: suspendScan scan wait compelete");
                }
            }
            return currentMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeScan() {
        Object object = this._stateLock;
        synchronized (object) {
            if (this.getMode() == Mode.SUSPENDED) {
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: Mode <== ENABLED");
                }
                this.setMode(Mode.ENABLED);
                this._stateLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocket getServerSocket() throws IOException {
        Object object = this._socketLock;
        synchronized (object) {
            if (this._socket == null) {
                this._socket = new ServerSocket(RecoveryManager.getRecoveryManagerPort(), 50, RecoveryManager.getRecoveryManagerHost());
                recoveryPropertyManager.getRecoveryEnvironmentBean().setRecoveryPort(this._socket.getLocalPort());
            }
            return this._socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.doInitialWait();
        boolean finished = false;
        do {
            boolean notifyRequired;
            boolean workToDo = false;
            Object object = this._stateLock;
            synchronized (object) {
                if (this.getStatus() == Status.SCANNING) {
                    if (tsLogger.logger.isDebugEnabled()) {
                        tsLogger.logger.debug((Object)"PeriodicRecovery: background thread waiting on other scan");
                    }
                    this.doScanningWait();
                    if (this.getMode() == Mode.ENABLED && !this._workerScanRequested) {
                        if (tsLogger.logger.isDebugEnabled()) {
                            tsLogger.logger.debug((Object)"PeriodicRecovery: background thread backing off");
                        }
                        this.doPeriodicWait();
                        finished = this.getMode() == Mode.TERMINATED;
                    }
                } else {
                    switch (this.getMode()) {
                        case ENABLED: {
                            if (tsLogger.logger.isDebugEnabled()) {
                                tsLogger.logger.debug((Object)"PeriodicRecovery: background thread Status <== SCANNING");
                            }
                            this.setStatus(Status.SCANNING);
                            this._stateLock.notifyAll();
                            workToDo = true;
                            break;
                        }
                        case SUSPENDED: {
                            if (tsLogger.logger.isDebugEnabled()) {
                                tsLogger.logger.debug((Object)"PeriodicRecovery: background thread wait while SUSPENDED");
                            }
                            this.doSuspendedWait();
                            finished = this.getMode() == Mode.TERMINATED;
                            break;
                        }
                        case TERMINATED: {
                            finished = true;
                        }
                    }
                }
            }
            if (!workToDo) continue;
            Object object2 = this._stateLock;
            synchronized (object2) {
                notifyRequired = this._workerScanRequested;
                this._workerScanRequested = false;
            }
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug((Object)"PeriodicRecovery: background thread scanning");
            }
            this.doWorkInternal();
            object2 = this._stateLock;
            synchronized (object2) {
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: background thread Status <== INACTIVE");
                }
                this.setStatus(Status.INACTIVE);
                this._stateLock.notifyAll();
                if (notifyRequired && !this._workerScanRequested) {
                    this.notifyWorker();
                }
                if (this.getMode() == Mode.ENABLED && !this._workerScanRequested) {
                    if (tsLogger.logger.isDebugEnabled()) {
                        tsLogger.logger.debug((Object)"PeriodicRecovery: background thread backing off");
                    }
                    this.doPeriodicWait();
                }
                finished = this.getMode() == Mode.TERMINATED;
            }
        } while (!finished);
        Object object = this._stateLock;
        synchronized (object) {
            if (this._workerScanRequested) {
                this.notifyWorker();
            }
        }
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)"PeriodicRecovery: background thread exiting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWork() {
        boolean workToDo = false;
        Object object = this._stateLock;
        synchronized (object) {
            if (this.getMode() == Mode.SUSPENDED) {
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: ad hoc thread wait while SUSPENDED");
                }
                this.doSuspendedWait();
            }
            if (this.getMode() == Mode.TERMINATED) {
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: ad hoc thread scan TERMINATED");
                }
            } else if (this.getStatus() == Status.SCANNING) {
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: ad hoc thread waiting on other scan");
                }
                this.doScanningWait();
            } else {
                this.setStatus(Status.SCANNING);
                this._stateLock.notifyAll();
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: ad hoc thread Status <== SCANNING");
                }
                workToDo = true;
            }
        }
        if (workToDo) {
            boolean notifyRequired;
            Object object2 = this._stateLock;
            synchronized (object2) {
                notifyRequired = this._workerScanRequested;
                this._workerScanRequested = false;
            }
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug((Object)"PeriodicRecovery: ad hoc thread scanning");
            }
            this.doWorkInternal();
            object2 = this._stateLock;
            synchronized (object2) {
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: ad hoc thread Status <== INACTIVE");
                }
                this.setStatus(Status.INACTIVE);
                this._stateLock.notifyAll();
                if (notifyRequired && !this._workerScanRequested) {
                    this.notifyWorker();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Object object = this._stateLock;
        synchronized (object) {
            this._workerScanRequested = true;
            if (this.getStatus() != Status.SCANNING) {
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: listener worker interrupts background thread");
                }
                this._stateLock.notifyAll();
            }
        }
    }

    public final void addModule(RecoveryModule module) {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("PeriodicRecovery: adding module " + module.getClass().getName()));
        }
        this._recoveryModules.add(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeModule(RecoveryModule module, boolean waitOnScan) {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("PeriodicRecovery: removing module " + module.getClass().getName()));
        }
        if (waitOnScan) {
            Object object = this._stateLock;
            synchronized (object) {
                this.doScanningWait();
            }
        }
        this._recoveryModules.remove(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllModules(boolean waitOnScan) {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)"PeriodicRecovery: removing all modules.");
        }
        if (waitOnScan) {
            Object object = this._stateLock;
            synchronized (object) {
                this.doScanningWait();
            }
        }
        this._recoveryModules.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Vector<RecoveryModule> getModules() {
        Vector<RecoveryModule> vector = this._recoveryModules;
        synchronized (vector) {
            return new Vector<RecoveryModule>(this._recoveryModules);
        }
    }

    public Listener getListener() {
        return this._listener;
    }

    private Status getStatus() {
        return this._currentStatus;
    }

    public Mode getMode() {
        return this._currentMode;
    }

    private void setStatus(Status status) {
        this._currentStatus = status;
    }

    private void setMode(Mode mode) {
        this._currentMode = mode;
    }

    private void doBackoffWait() {
        try {
            this._stateLock.wait((long)this._backoffPeriod * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doPeriodicWait() {
        try {
            this._stateLock.wait((long)this._recoveryPeriod * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialWait() {
        if (this._periodicRecoveryInitilizationOffset > 0) {
            try {
                Object object = this._stateLock;
                synchronized (object) {
                    this._stateLock.wait((long)this._periodicRecoveryInitilizationOffset * 1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void doSuspendedWait() {
        while (this.getMode() == Mode.SUSPENDED) {
            try {
                this._stateLock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void doScanningWait() {
        while (this.getStatus() == Status.SCANNING) {
            try {
                this._stateLock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWorkInternal() {
        ClassLoader cl;
        Object m;
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("Periodic recovery first pass at " + this._theTimestamper.format(new Date())));
        }
        Vector<RecoveryModule> copyOfModules = this.getModules();
        Enumeration<RecoveryModule> modules = copyOfModules.elements();
        while (modules.hasMoreElements()) {
            m = modules.nextElement();
            cl = this.switchClassLoader((RecoveryModule)m);
            try {
                m.periodicWorkFirstPass();
            }
            finally {
                this.restoreClassLoader(cl);
            }
            if (!tsLogger.logger.isDebugEnabled()) continue;
            tsLogger.logger.debug((Object)" ");
        }
        m = this._stateLock;
        synchronized (m) {
            this.doBackoffWait();
            if (this.getMode() == Mode.TERMINATED) {
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)"PeriodicRecovery: scan TERMINATED at phase 1");
                }
                return;
            }
        }
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("Periodic recovery second pass at " + this._theTimestamper.format(new Date())));
        }
        modules = copyOfModules.elements();
        while (modules.hasMoreElements()) {
            m = modules.nextElement();
            cl = this.switchClassLoader((RecoveryModule)m);
            try {
                m.periodicWorkSecondPass();
            }
            finally {
                this.restoreClassLoader(cl);
            }
            if (!tsLogger.logger.isDebugEnabled()) continue;
            tsLogger.logger.debug((Object)" ");
        }
    }

    private void notifyWorker() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)"PeriodicRecovery: scan thread signals listener worker");
        }
        if (this._workerService != null) {
            this._workerService.notifyDone();
        }
        this._workerScanRequested = false;
    }

    private ClassLoader switchClassLoader(RecoveryModule rm) {
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(rm.getClass().getClassLoader());
        return cl;
    }

    private void restoreClassLoader(ClassLoader cl) {
        Thread currentThread = Thread.currentThread();
        currentThread.setContextClassLoader(cl);
    }

    private void loadModules() {
        this._recoveryModules.addAll(recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryModules());
    }

    private void initialise() {
        this.setStatus(Status.INACTIVE);
        this.setMode(Mode.ENABLED);
        this._recoveryPeriod = recoveryPropertyManager.getRecoveryEnvironmentBean().getPeriodicRecoveryPeriod();
        if (this._recoveryPeriod != 120 && tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("com.arjuna.ats.arjuna.recovery.PeriodicRecovery: Recovery period set to " + this._recoveryPeriod + " seconds"));
        }
        this._backoffPeriod = recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryBackoffPeriod();
        if (this._backoffPeriod != 10 && tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("PeriodicRecovery: Backoff period set to " + this._backoffPeriod + " seconds"));
        }
        this._periodicRecoveryInitilizationOffset = recoveryPropertyManager.getRecoveryEnvironmentBean().getPeriodicRecoveryInitilizationOffset();
    }

    public static enum Mode {
        ENABLED,
        SUSPENDED,
        TERMINATED;

    }

    public static enum Status {
        INACTIVE,
        SCANNING;

    }
}

