# Installation

To automatically install the Node squashfs image you need a kickstart file.
Alternatively, you can generate an ISO with `make offline-installation-iso`

## Overview

`Anaconda` is the installation program used by Fedora, Red Hat Enterprise Linux,
CentOS and some other distributions. It allows the user to install the operating
system software on the target computer. Additionally, it can also upgrade
existing installations of earlier versions of the same distribution.

### Functionality provided by Anaconda

*   Automatically create partitions

*   `LVM Thin Provisioning` support helps users to make snapshot and
rollbacks in the system.

*   Anaconda can install disk images instead of packages with the `liveimg`
directive.

Anaconda does not need any modifications to provide the functionality required
for Node. In addition, Node works with all other features of Anaconda without
limitations. This means that you can use %pre, %post, configure the timezone,
selinux, add users, configure networking, and everything else you can normally
do with Anaconda.

***Note that %packages cannot be used with the `liveimg` directive. If you want
to install additional packages, please do so in %post***

## Installation from an ISO

A ready-to-use installation ISO can be generated by running `make
offline-installation-iso`, or downloaded from [oVirt Jenkins](
http://jenkins.ovirt.org/search/?q=ovirt-node-ng)

## Automated installs with Anaconda Kickstart

`kickstart` is a domain-specific languages used for automating Anaconda to
install operationg systems.

System administrators and/or developers can create a single kickstart file
(these normally have `.ks` as an extension) containing the answers to all the
questions that would normally be asked during a typical installation, as well
as providing a way to perform some steps before and after the installation
through the `%pre` and `%post` directives.

The minimal required kickstart parameters for oVirt Node are `liveimg` and the
correct partitioning. Anaconda then will use that kickstart to automatically
perform the installation.

The `liveimg` directive for oVirt Node should be directed at
`ovirt-node-ng-image.squashfs`, but it also supports other targets, which are
not used by oVirt Node. See the [Anaconda Documentation](
https://github.com/rhinstaller/pykickstart/blob/master/docs/kickstart-docs.rst)
for more information.

## Anaconda Boot Options

To start a Kickstart installation, a special boot option `inst.ks=` must be
specified when booting the system.

## Example: Manual installation of Node from a webserver

### Install httpd

`httpd` or another web server must be installed on a separate host.

    $ sudo yum -y install httpd
    $ sudo systemctl start httpd
    $ sudo systemctl enable httpd

### Publish the `squashfs` image

Build locally the ovirt-node-ng squashfs image or download the last successful
image from [oVirt Jenkins](http://jenkins.ovirt.org/search/?q=ovirt-node-ng)
for the version of Node you'd like to install, and make it available on the
web server.

    $ cd /var/www/html
    $ wget http://jenkins.ovirt.org/job/ovirt-appliance-node_master_create-squashfs-el7_merged/lastSuccessfulBuild/artifact/exported-artifacts/ovirt-node-ng-image.squashfs.img

### Create the kickstart

Create a `minimal-ngn.ks` in the httpd public dir

    $ cat minimal-ngn.ks
    autopart --type=thinp

    liveimg --url=http://server/ovirt-node-ng-image.squashfs.img

    %post
    imgbase layout --init
    %end

If you'd like to set your own partitioning manually, the following is a
reasonable example. Note that LVM thin pools must be used, with thin volumes:

## Or for a manual layout

reqpart --add-boot
part pv.01 --size=42000 --grow
volgroup HostVG pv.01
logvol swap --vgname=HostVG --name=swap --fstype=swap --recommended
logvol none --vgname=HostVG --name=HostPool --thinpool --size=40000 --grow
logvol /    --vgname=HostVG --name=root --thin --poolname=HostPool --fsoptions="defaults,discard" --size=6000
logvol /var --vgname=HostVG --name=var --thin --poolname=HostPool --fsoptions="defaults,discard" --size=15000

## Start the installation

At this stage, you should be able to proceed with the installation, adding
`inst.ks=http://server/minimal-ngn.ks` as a kernel argument.

In addition, `product.img` and `updates.img` are published on oVirt Jenkins, and
can be generated locally with `make product.img updates.img`. These images
should be passed on the kernel command line as `inst.updates` in order to enable
automatic partitioning.

## PXE Installation

oVirt Node can easily be installed over the network. The same parameters as an
automatic install are given. An example `pxelinux.cfg/default` stanza is:

    LABEL ovirt
        MENU LABEL ^oVirt Node
        KERNEL ovirt/vmlinuz
        APPEND initrd=rhv/ovirt.img inst.ks=http://webserver/ovirt.ks inst.stage2=http://webserver/stage2/ovirt/ verbose

`inst.stage2` should point at a tree containing `updates.img` and `product.img`.

See the Anaconda documentation for more information.

## USB Media creation and installation

1.  Fetch a CentOS 7 installation ISO

2.  Create a kickstart file using: `echo "liveimg
--url=file://ovirt-node-ng-image.squashfs.img" > liveimg-install.ks`

3.  Run `livecd-iso-to-disk --ks liveimg-install.ks $CENTOS_ISO $DISK`

4.  Mount the created disk, and copy the squashfs image to the same directory
as the `liveimg-install.ks` file.

## Additional references

Kickstart Documentation
`https://github.com/rhinstaller/pykickstart/blob/master/docs/kickstart-docs.rst`
