# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%global _ovirtwebuidir %{_datarootdir}/ovirt-web-ui
%global _ovirt_engine_conf %{_datarootdir}/ovirt-engine/services/ovirt-engine/ovirt-engine.conf
%global _ovirt_engine_ear_application_xml %{_datarootdir}/ovirt-engine/engine.ear/META-INF/application.xml
%global product oVirt

%global use_rhev %( test -z @RHEV@ && echo 1 || echo 0)
%define debug_package %{nil}

## %global source_basename ovirt-web-ui-1.2.1
%global source_basename ovirt-web-ui

Name:           ovirt-web-ui
Version:        1.2.1
Release:        1%{?release_suffix}%{?checkout}%{?dist}
Summary:        VM Portal for %{product}
License:        ASL 2.0
URL:            https://github.com/oVirt/ovirt-web-ui
Source0:        https://github.com/oVirt/ovirt-web-ui/archive/%{source_basename}-1.2.1.tar.gz

BuildArch: noarch

# Keep ovirt-engine-{nodejs|nodejs-modules|yarn} at particular version unless tested on higher
BuildRequires: ovirt-engine-nodejs = 8.0.0
BuildRequires: ovirt-engine-yarn = 0.24.4

# contains ovirt-ui-components-0.2.5
BuildRequires: ovirt-engine-nodejs-modules = 1.1.0

%description
This package provides new VM Portal for %{product}, so far as technical preview.

%prep
# Use the ovirt-engine nodejs installation
# export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"

%setup -q -n"%{source_basename}-%{version}"
rpm -qa | grep ovirt-engine-nodejs
source /usr/share/ovirt-engine-nodejs-modules/setup-env.sh

%build
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:%{_datadir}/ovirt-engine-yarn/bin:${PATH}"
%configure
export PATH="./node_modules/.bin:${PATH}"
make

%install
make install DESTDIR=%{buildroot}

%files
%doc README.md 
%license LICENSE
%{_ovirtwebuidir}
%{_datarootdir}/ovirt-engine/ovirt-web-ui.war
%{_sysconfdir}/ovirt-engine/engine.conf.d/50-ovirt-web-ui.conf
%{_sysconfdir}/ovirt-web-ui/branding/00-ovirt.brand

%changelog
* Wed Aug 16 2017 Marek Libra <mlibra@redhat.com> - 1.2.1
- noarch rpm
- minor fixes, runtime dependencies generally updated
- usb-filter in .vv file
- basics for internationalization, but translation missing

* Wed Aug 2 2017 Marek Libra <mlibra@redhat.com> - 1.2.0
- branding
- infinite scroller for VMS list
- Change CD function
- "Runs on Host" - hyperlink to the host running particular VM
- "Loading ..." indicator of background activity
- "Pending Changes" tag rendered when NEXT_RUN configuration exists
- VM Type
- error messages improved
- fixed setting of VM icon
- multiple additional functional & UI fixes

* Tue Jun 20 2017 Marek Libra <mlibra@redhat.com> - 1.1.0
- Navigation via list of VMs to see details simplified
- Component for VM's Disks redesigned
- Context-based help
- Support for RDP graphics consoles
- ESC key used as back-button
- multiple UI fixes and improvements
- Configuration of graphics console added

* Fri Jun 2 2017 Marek Libra <mlibra@redhat.com> - 1.0.0
- "Door effect" removed, replaced by standard patternfly design
- User Messages are not closed automatically
- Check "Console in use" added
* Mon May 15 2017 Marek Libra <mlibra@redhat.com> - 0.2.2
- Minor fixes for pools
* Mon May 15 2017 Marek Libra <mlibra@redhat.com> - 0.2.1
- React and Redux updated to latest version
* Fri May 12 2017 Marek Libra <mlibra@redhat.com> - 0.2.0
- Add/Edit VM Dialog
- Autoconnect and Console options
- VM Pools
- the Remove VM action
- confirmation dialog improved
- functionality and UI fixes
* Wed Apr 19 2017 Marek Libra <mlibra@redhat.com> - 0.1.4
- Confirmation component
- About dialog
- UI fixes
- docker builds
- stability fixes
* Wed Apr 12 2017 Marek Libra <mlibra@redhat.com> - 0.1.3
- UI fixes
- docker builds
- oVirt API version check
- About dialog
* Mon Feb 20 2017 Marek Libra <mlibra@redhat.com> - 0.1.2
- Minor UI fixes, npm replaced by yarn
* Fri Dec 16 2016 Marek Libra <mlibra@redhat.com> - 0.1.1
- Minor UI fixes, authorizedRedirect.jsp
* Mon Nov 14 2016 Marek Libra <mlibra@redhat.com> - 0.1.0
- First version, Technical Preview
